/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class Split
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length >= 2 && args.length <= 3) {
            Object preserve;
            boolean preserveAllTokens = false;
            Object v = args[0];
            Object split = args[1];
            if (args.length == 3 && (preserve = args[2]) instanceof Boolean) {
                preserveAllTokens = (Boolean)preserve;
            }
            if (v != null && split != null) {
                String str;
                String string = str = v instanceof String ? (String)v : v.toString();
                if (split instanceof String) {
                    return preserveAllTokens ? StringUtils.splitByWholeSeparatorPreserveAllTokens((String)str, (String)((String)split)) : StringUtils.splitByWholeSeparator((String)str, (String)((String)split));
                }
                if (split instanceof Pattern) {
                    Pattern pattern = (Pattern)split;
                    return pattern.split(str);
                }
            }
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects 2 strings, or 1 string and 1 regex, followed by an optional boolean");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Split.DOCUMENTATION", "Returns the array of strings obtained by splitting <code>s</code> with separator <code>sep</code>. If <code>preserveAllTokens</code> is true, then empty segments are preserved.").withParams("string s, string or regex sep, [boolean preserveAllTokens]").withReturns("array").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("\"hello world\"", "\" \"").returns("[\"hello\", \"world\"]"));
    }
}

