/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.signoff;

import com.dataiku.gh.core.utils.ValidatorUtils;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SignoffId {
    public String artifactId;
    public String stepId;

    public static SignoffId build(String artifactId, String stepId) {
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)artifactId), "artifactId is required", new Object[0]);
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)stepId), "stepId is required", new Object[0]);
        SignoffId signoffId = new SignoffId();
        signoffId.artifactId = artifactId;
        signoffId.stepId = stepId;
        return signoffId;
    }

    public String toString() {
        return "SignoffId{artifactId='" + this.artifactId + "', stepId='" + this.stepId + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignoffId signoffId = (SignoffId)o;
        return Objects.equals(this.artifactId, signoffId.artifactId) && Objects.equals(this.stepId, signoffId.stepId);
    }

    public int hashCode() {
        return Objects.hash(this.artifactId, this.stepId);
    }
}

