/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation.validators;

import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.gh.core.models.roles.assignments.BlueprintRoleAssignments;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.services.validation.validators.RoleAssignmentsRulesValidator;
import com.dataiku.gh.core.storage.blueprints.IBlueprintDAO;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.core.visitors.IBlueprintRoleAssignmentsVisitor;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class BlueprintRoleAssignmentsValidator
extends RoleAssignmentsRulesValidator
implements IBlueprintRoleAssignmentsVisitor {
    private final String blueprintId;

    public BlueprintRoleAssignmentsValidator(BlueprintRoleAssignments blueprintRoleAssignments) {
        super(blueprintRoleAssignments.blueprintId);
        this.blueprintId = blueprintRoleAssignments.blueprintId;
    }

    @Override
    public void visit(BlueprintRoleAssignments blueprintRoleAssignments) {
        if (!IdentifiersUtils.isValidBlueprintId(blueprintRoleAssignments.blueprintId)) {
            throw new ValidationException("Invalid blueprint ID: " + blueprintRoleAssignments.blueprintId);
        }
    }

    public void validateBlueprint(IBlueprintDAO blueprintDAO) throws IOException {
        if (!blueprintDAO.exists(this.blueprintId)) {
            throw new NotFoundException("Blueprint not found: " + this.blueprintId);
        }
    }

    public void validateInheritedBlueprints(IBlueprintDAO blueprintDAO, List<String> inheritedBlueprintIds) throws IOException {
        for (String inheritedBlueprintId : inheritedBlueprintIds) {
            if (!StringUtils.isNotBlank((CharSequence)inheritedBlueprintId) || blueprintDAO.exists(inheritedBlueprintId)) continue;
            throw new NotFoundException("Inherited blueprint ID not found: " + inheritedBlueprintId);
        }
    }
}

