/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation.validators;

import com.dataiku.gh.core.models.subscriptions.Subscription;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.core.utils.ValidatorUtils;
import com.dataiku.gh.core.visitors.ISubscriptionVisitor;
import org.apache.commons.lang3.StringUtils;

public class SubscriptionValidator
implements ISubscriptionVisitor {
    @Override
    public void visit(Subscription subscription) {
        ValidatorUtils.validateThat(subscription.subscriptionId != null, "Subscription ID cannot be null", new Object[0]);
        ValidatorUtils.validateThat(IdentifiersUtils.isValidArtifactId(subscription.subscriptionId.artifactId), "Invalid artifact Id: '%s'", subscription.subscriptionId.artifactId);
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)subscription.subscriptionId.userLogin), "User login cannot be blank", new Object[0]);
        ValidatorUtils.validateThat(subscription.subscriptionLevel != null, "Subscription level cannot be null", new Object[0]);
    }
}

