/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.noding.OrientedCoordinateArray;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class EdgeList {
    private List edges = new ArrayList();
    private Map ocaMap = new TreeMap();

    public void add(Edge e) {
        this.edges.add(e);
        OrientedCoordinateArray oca = new OrientedCoordinateArray(e.getCoordinates());
        this.ocaMap.put(oca, e);
    }

    public void addAll(Collection edgeColl) {
        Iterator i = edgeColl.iterator();
        while (i.hasNext()) {
            this.add((Edge)i.next());
        }
    }

    public List getEdges() {
        return this.edges;
    }

    public Edge findEqualEdge(Edge e) {
        OrientedCoordinateArray oca = new OrientedCoordinateArray(e.getCoordinates());
        Edge matchEdge = (Edge)this.ocaMap.get(oca);
        return matchEdge;
    }

    public Iterator iterator() {
        return this.edges.iterator();
    }

    public Edge get(int i) {
        return (Edge)this.edges.get(i);
    }

    public int findEdgeIndex(Edge e) {
        int i = 0;
        while (i < this.edges.size()) {
            if (((Edge)this.edges.get(i)).equals(e)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void print(PrintStream out) {
        out.print("MULTILINESTRING ( ");
        int j = 0;
        while (j < this.edges.size()) {
            Edge e = (Edge)this.edges.get(j);
            if (j > 0) {
                out.print(",");
            }
            out.print("(");
            Coordinate[] pts = e.getCoordinates();
            int i = 0;
            while (i < pts.length) {
                if (i > 0) {
                    out.print(",");
                }
                out.print(String.valueOf(pts[i].x) + " " + pts[i].y);
                ++i;
            }
            out.println(")");
            ++j;
        }
        out.print(")  ");
    }
}

