/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph.index;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.index.MonotoneChainIndexer;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;

public class MonotoneChainEdge {
    Edge e;
    Coordinate[] pts;
    int[] startIndex;
    Envelope env1 = new Envelope();
    Envelope env2 = new Envelope();

    public MonotoneChainEdge(Edge e) {
        this.e = e;
        this.pts = e.getCoordinates();
        MonotoneChainIndexer mcb = new MonotoneChainIndexer();
        this.startIndex = mcb.getChainStartIndices(this.pts);
    }

    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    public int[] getStartIndexes() {
        return this.startIndex;
    }

    public double getMinX(int chainIndex) {
        double x1 = this.pts[this.startIndex[chainIndex]].x;
        double x2 = this.pts[this.startIndex[chainIndex + 1]].x;
        return x1 < x2 ? x1 : x2;
    }

    public double getMaxX(int chainIndex) {
        double x1 = this.pts[this.startIndex[chainIndex]].x;
        double x2 = this.pts[this.startIndex[chainIndex + 1]].x;
        return x1 > x2 ? x1 : x2;
    }

    public void computeIntersects(MonotoneChainEdge mce, SegmentIntersector si) {
        int i = 0;
        while (i < this.startIndex.length - 1) {
            int j = 0;
            while (j < mce.startIndex.length - 1) {
                this.computeIntersectsForChain(i, mce, j, si);
                ++j;
            }
            ++i;
        }
    }

    public void computeIntersectsForChain(int chainIndex0, MonotoneChainEdge mce, int chainIndex1, SegmentIntersector si) {
        this.computeIntersectsForChain(this.startIndex[chainIndex0], this.startIndex[chainIndex0 + 1], mce, mce.startIndex[chainIndex1], mce.startIndex[chainIndex1 + 1], si);
    }

    private void computeIntersectsForChain(int start0, int end0, MonotoneChainEdge mce, int start1, int end1, SegmentIntersector ei) {
        Coordinate p00 = this.pts[start0];
        Coordinate p01 = this.pts[end0];
        Coordinate p10 = mce.pts[start1];
        Coordinate p11 = mce.pts[end1];
        if (end0 - start0 == 1 && end1 - start1 == 1) {
            ei.addIntersections(this.e, start0, mce.e, start1);
            return;
        }
        this.env1.init(p00, p01);
        this.env2.init(p10, p11);
        if (!this.env1.intersects(this.env2)) {
            return;
        }
        int mid0 = (start0 + end0) / 2;
        int mid1 = (start1 + end1) / 2;
        if (start0 < mid0) {
            if (start1 < mid1) {
                this.computeIntersectsForChain(start0, mid0, mce, start1, mid1, ei);
            }
            if (mid1 < end1) {
                this.computeIntersectsForChain(start0, mid0, mce, mid1, end1, ei);
            }
        }
        if (mid0 < end0) {
            if (start1 < mid1) {
                this.computeIntersectsForChain(mid0, end0, mce, start1, mid1, ei);
            }
            if (mid1 < end1) {
                this.computeIntersectsForChain(mid0, end0, mce, mid1, end1, ei);
            }
        }
    }
}

