/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.audit;

import com.dataiku.dip.security.audit.IAuditTrailBufferService;
import com.google.common.base.Predicate;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import org.springframework.stereotype.Service;

@Service
public class AuditTrailBufferService
implements IAuditTrailBufferService {
    public static final int BUFFER_LIMIT = 1000;
    private EvictingQueue<IAuditTrailBufferService.AuditBufferEvent> fifo = EvictingQueue.create((int)1000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String supertype, JsonObject obj) {
        IAuditTrailBufferService.AuditBufferEvent abe = new IAuditTrailBufferService.AuditBufferEvent();
        abe.superType = supertype;
        abe.obj = obj;
        EvictingQueue<IAuditTrailBufferService.AuditBufferEvent> evictingQueue = this.fifo;
        synchronized (evictingQueue) {
            this.fifo.add((Object)abe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAuditTrailBufferService.AuditBuffer get(boolean includeAllCalls) {
        IAuditTrailBufferService.AuditBuffer buf = new IAuditTrailBufferService.AuditBuffer();
        EvictingQueue<IAuditTrailBufferService.AuditBufferEvent> evictingQueue = this.fifo;
        synchronized (evictingQueue) {
            buf.events = Lists.newArrayList(this.fifo);
        }
        if (!includeAllCalls) {
            buf.events = FluentIterable.from(buf.events).filter((Predicate)new Predicate<IAuditTrailBufferService.AuditBufferEvent>(){

                public boolean apply(IAuditTrailBufferService.AuditBufferEvent arg0) {
                    return !"allcalls".equals(arg0.superType);
                }
            }).toList();
        }
        buf.events = Lists.reverse(buf.events);
        return buf;
    }
}

