/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.custom;

import com.dataiku.dip.security.auth.CustomAuthSettings;
import com.dataiku.dip.security.auth.ServerAuthenticationFailure;
import com.dataiku.dip.security.auth.UserAuthenticationException;
import com.dataiku.dip.security.auth.UserCredentialsAuthenticator;
import com.dataiku.dip.security.auth.UserCredentialsAuthenticatorSettings;
import com.dataiku.dip.security.auth.UserIdentity;
import com.dataiku.dip.security.custom.CustomUserAuthenticator;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.StringUtils;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;

public class CustomUserAuthenticatorDelegator
implements UserCredentialsAuthenticator {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth");
    protected CustomAuthSettings customAuthSettings;
    private CustomUserAuthenticator customUserAuthenticator;

    @Override
    public UserCredentialsAuthenticatorSettings getAuthenticatorSettings() {
        return this.customAuthSettings;
    }

    @Override
    public UserIdentity authenticate(String inputLogin, String password) throws ServerAuthenticationFailure, UserAuthenticationException {
        try {
            return this.getCustomUserAuthenticator().authenticate(inputLogin, password);
        }
        catch (ServerAuthenticationFailure | UserAuthenticationException e) {
            logger.info((Object)("Custom authenticator could not authenticate login '" + inputLogin + "'"), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            throw new ServerAuthenticationFailure("An expected error happened in the custom authenticator '" + this.customAuthSettings.customUserAuthenticatorClassName + "'", e);
        }
    }

    @VisibleForTesting
    public CustomUserAuthenticator getCustomUserAuthenticator() throws ServerAuthenticationFailure {
        if (StringUtils.nullIfBlank((String)this.customAuthSettings.customUserAuthenticatorClassName) != null) {
            if (this.customUserAuthenticator == null || !this.customAuthSettings.customUserAuthenticatorClassName.equals(this.customUserAuthenticator.getClass().getName())) {
                try {
                    Class<?> customUserAuthenticatorClass = CustomUserAuthenticator.class.getClassLoader().loadClass(this.customAuthSettings.customUserAuthenticatorClassName);
                    if (SpringUtils.getInstance().hasBeanNames(customUserAuthenticatorClass)) {
                        logger.info((Object)("Found a spring bean matching the class: " + this.customAuthSettings.customUserAuthenticatorClassName));
                        this.customUserAuthenticator = (CustomUserAuthenticator)SpringUtils.getBean(customUserAuthenticatorClass);
                    } else {
                        logger.info((Object)("Loading CustomUserAuthenticator class: " + this.customAuthSettings.customUserAuthenticatorClassName));
                        this.customUserAuthenticator = (CustomUserAuthenticator)customUserAuthenticatorClass.newInstance();
                        SpringUtils.getInstance().registerSingletonBeanIfNotPresent(this.customUserAuthenticator.getClass(), this.customUserAuthenticator);
                        logger.info((Object)("CustomUserAuthenticator found in classpath: " + this.customUserAuthenticator.getClass().getName()));
                    }
                }
                catch (ClassCastException e) {
                    logger.errorV("Class '%s' doesn't implement interface '%s'.", new Object[]{this.customAuthSettings.customUserAuthenticatorClassName, CustomUserAuthenticator.class.getName()});
                    throw new ServerAuthenticationFailure("Class '" + this.customAuthSettings.customUserAuthenticatorClassName + "' doesn't implement interface '" + CustomUserAuthenticator.class.getName() + "'.", e);
                }
                catch (ClassNotFoundException e) {
                    logger.errorV("No CustomUserAuthenticator '%s' found in classpath.", new Object[]{this.customAuthSettings.customUserAuthenticatorClassName});
                    throw new ServerAuthenticationFailure("No CustomUserAuthenticator '" + this.customAuthSettings.customUserAuthenticatorClassName + "' found in classpath.", e);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    logger.errorV((Throwable)e, "Could not load CustomUserAuthenticator '%s' found in classpath.", new Object[]{this.customAuthSettings.customUserAuthenticatorClassName});
                    throw new ServerAuthenticationFailure("No CustomUserAuthenticator '" + this.customAuthSettings.customUserAuthenticatorClassName + "' found in classpath.", e);
                }
            }
            return this.customUserAuthenticator;
        }
        logger.info((Object)"No CustomUserAuthenticator defined");
        throw new ServerAuthenticationFailure("The CustomUserAuthenticator class '" + this.customAuthSettings.customUserAuthenticatorClassName + "' could not be loaded.");
    }
}

