/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git;

import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.GitModel;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CommitDef {
    public final GitModel.GitAuthor author;
    public final String message;
    public final Set<RelFile> changes;
    public final List<String> filePatterns;

    public CommitDef(GitModel.GitAuthor author, String msg, Collection<RelFile> changes) {
        Preconditions.checkNotNull((Object)author);
        this.author = author;
        this.message = msg;
        this.changes = Collections.unmodifiableSet(new HashSet<RelFile>(changes));
        this.filePatterns = null;
    }

    public CommitDef(GitModel.GitAuthor author, String msg, List<String> filePatterns) {
        Preconditions.checkNotNull((Object)author);
        this.author = author;
        this.message = msg;
        this.changes = null;
        this.filePatterns = filePatterns;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CommitDef) {
            CommitDef cd = (CommitDef)obj;
            return Objects.equal(cd.changes, this.changes) && Objects.equal(cd.filePatterns, this.filePatterns) && Objects.equal((Object)this.author, (Object)cd.author) && Objects.equal((Object)this.author.email, (Object)cd.author.email) && Objects.equal((Object)this.message, (Object)cd.message);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.author.name).append("] ").append(this.message).append(" : \n");
        if (this.changes != null) {
            for (RelFile rf : this.changes) {
                sb.append(" - ").append(rf).append("\n");
            }
        } else {
            for (String pattern : this.filePatterns) {
                sb.append(" - ").append(pattern).append("\n");
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        return 0;
    }
}

