/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git;

import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.CommitDef;
import com.dataiku.dip.transactions.git.IGitManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CommitQueue {
    private final List<ScheduledCommit> commits = new ArrayList<ScheduledCommit>();
    private final IGitManager gitManager;
    private static final Logger logger = Logger.getLogger(CommitQueue.class);

    public CommitQueue(IGitManager gitManager) {
        this.gitManager = gitManager;
    }

    private List<ScheduledCommit> findAliased(CommitDef def) {
        ArrayList<ScheduledCommit> out = new ArrayList<ScheduledCommit>();
        for (ScheduledCommit sc : this.commits) {
            boolean alias = false;
            block1: for (RelFile rf1 : sc.def.changes) {
                for (RelFile rf2 : def.changes) {
                    if (!rf1.isAncestorOf(rf2) && !rf2.isAncestorOf(rf1)) continue;
                    alias = true;
                    continue block1;
                }
            }
            if (!alias) continue;
            out.add(sc);
        }
        return out;
    }

    private List<ScheduledCommit> findExpired() {
        long now = System.currentTimeMillis();
        ArrayList<ScheduledCommit> out = new ArrayList<ScheduledCommit>();
        for (ScheduledCommit sc : this.commits) {
            if (sc.scheduledTime > now) continue;
            out.add(sc);
        }
        return out;
    }

    private List<ScheduledCommit> findSimilar(CommitDef def) {
        ArrayList<ScheduledCommit> out = new ArrayList<ScheduledCommit>();
        for (ScheduledCommit sc : this.commits) {
            if (!sc.def.equals(def)) continue;
            out.add(sc);
        }
        return out;
    }

    public synchronized void commitIfAliasedButNotEquals(CommitDef def) throws IOException {
        List<ScheduledCommit> aliasedDifferent = this.findAliased(def);
        for (ScheduledCommit sc : aliasedDifferent) {
            if (def.equals(sc.def)) continue;
            this.commits.remove(sc);
            logger.debug((Object)("Flushed Git commit:\n" + String.valueOf(sc.def)));
            this.gitManager.commit(sc.def);
        }
    }

    public synchronized void scheduleOrExecCommit(CommitDef def, long delayMillis) throws IOException {
        boolean removed = false;
        for (ScheduledCommit sc : this.findSimilar(def)) {
            logger.debug((Object)("Re-scheduled Git commit in " + delayMillis + "ms:\n" + String.valueOf(sc.def)));
            this.commits.remove(sc);
            removed = true;
        }
        if (delayMillis == 0L) {
            logger.debug((Object)("Executing Git commit:\n" + String.valueOf(def)));
            this.gitManager.commit(def);
        } else {
            if (!removed) {
                logger.debug((Object)("Scheduled Git commit in " + delayMillis + "ms:\n" + String.valueOf(def)));
            }
            ScheduledCommit sd = new ScheduledCommit(def, System.currentTimeMillis() + delayMillis);
            this.commits.add(sd);
        }
    }

    public synchronized boolean hasExpired() {
        return !this.findExpired().isEmpty();
    }

    public synchronized void commitExpired() throws IOException {
        List<ScheduledCommit> expired = this.findExpired();
        for (ScheduledCommit sc : expired) {
            this.commits.remove(sc);
            logger.debug((Object)("Executed expired Git commit:\n" + String.valueOf(sc.def)));
            this.gitManager.commit(sc.def);
        }
    }

    public synchronized void commitAll() throws IOException {
        for (ScheduledCommit sc : this.commits) {
            logger.debug((Object)("Executed Git commit:\n" + String.valueOf(sc.def)));
            this.gitManager.commit(sc.def);
        }
        this.commits.clear();
    }

    public static class ScheduledCommit {
        public final CommitDef def;
        public final long scheduledTime;

        ScheduledCommit(CommitDef def, long time) {
            this.def = def;
            this.scheduledTime = time;
        }
    }
}

