/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils.j3ts;

import com.dataiku.dip.transactions.fs.InMemoryFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.j3ts.ClassScanner;
import com.dataiku.dip.utils.j3ts.PyFileEmitter;
import com.dataiku.dip.utils.j3ts.PyMappedType;
import com.dataiku.dip.utils.j3ts.PyTypeMapper;
import com.dataiku.dip.utils.j3ts.Translator;
import com.dataiku.j2py.annotations.PyModel;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class PyTranslator
extends Translator {
    public PyTranslator(File installDir, File outputDirectory, boolean shouldGenerateMetadata) {
        super(installDir, outputDirectory, shouldGenerateMetadata);
    }

    @Override
    public void translate() throws Exception {
        Stopwatch sw = Stopwatch.createStarted();
        for (ClassScanner.RootMapping rootMapping : this.rootMappings) {
            System.out.println("[+] Root mapping");
            System.out.println("[+]   - Scan from: " + rootMapping.directoryOrJarName);
            File outDir = rootMapping.targetDirectory != null ? new File(this.outputDirectory, rootMapping.targetDirectory.toString()) : this.outputDirectory;
            System.out.println("[+]   - Output in: " + String.valueOf(outDir));
        }
        System.out.println("[+] Output directory: " + this.outputDirectory.getAbsolutePath());
        ClassScanner classScanner = new ClassScanner(PyModel.class, this.rootMappings, this.inputDirectory);
        List<Class<?>> entryPoints = classScanner.scanEntryPoints();
        PyTypeMapper typeMapper = new PyTypeMapper(classScanner);
        List<PyMappedType> exploredTypes = PyTranslator.exploreFromEntryPoints(typeMapper, entryPoints);
        InMemoryFS files = this.generateFiles(exploredTypes, classScanner, this.shouldGenerateMetadata);
        PyTranslator.syncChangesToDisk(files, this.outputDirectory);
        System.out.println("[+] Done! Total time: " + DKUtils.getElapsed((Stopwatch)sw));
    }

    protected static List<PyMappedType> exploreFromEntryPoints(PyTypeMapper typeMapper, List<Class<?>> entryPoints) throws Exception {
        Stopwatch sw = Stopwatch.createStarted();
        for (Class<?> clazz : entryPoints) {
            typeMapper.mapTypeAndGenerateUnion(clazz);
        }
        List<PyMappedType> mappedTypes = typeMapper.getAllMappedTypes();
        System.out.println("[+] Translate types: " + DKUtils.getElapsed((Stopwatch)sw) + " (" + mappedTypes.size() + " types)");
        return mappedTypes;
    }

    private MetadataFile generateMetadata(List<PyMappedType> mappedTypes) {
        MetadataFile metadata = new MetadataFile();
        for (PyMappedType mt : mappedTypes) {
            if (mt.definitionFileNoExt == null) continue;
            metadata.mappings.add(mt.getPersistedTypeMeta());
        }
        metadata.mappings.sort(Comparator.comparing(o -> o.javaType));
        return metadata;
    }

    private InMemoryFS generateFiles(List<PyMappedType> mappedTypes, ClassScanner classScanner, boolean shouldGenerateMetadata) throws IOException {
        Stopwatch sw = Stopwatch.createStarted();
        TreeMap<RelFile, PyFileEmitter> files = new TreeMap<RelFile, PyFileEmitter>();
        TreeSet<RelFile> currentSourcePaths = new TreeSet<RelFile>();
        currentSourcePaths.add(classScanner.getSourceFileForClassIfExists(this.getClass()).getParent());
        for (PyMappedType pyMappedType : mappedTypes) {
            RelFile sourceFile = classScanner.getSourceFileForClassIfExists(pyMappedType.javaType);
            if (sourceFile != null) {
                currentSourcePaths.add(sourceFile);
            }
            if (pyMappedType.definitionFileNoExt == null) continue;
            PyFileEmitter fileEmitter = (PyFileEmitter)files.get(pyMappedType.definitionFileNoExt);
            if (fileEmitter == null) {
                fileEmitter = new PyFileEmitter(new RelFile(pyMappedType.definitionFileNoExt));
                files.put(pyMappedType.definitionFileNoExt, fileEmitter);
            }
            fileEmitter.writeTypeDefinition(pyMappedType);
        }
        InMemoryFS tmpFs = new InMemoryFS();
        for (PyFileEmitter fileEmitter : files.values()) {
            tmpFs.writeStringUTF8(String.valueOf(fileEmitter.definitionFileNameNoExt) + ".py", fileEmitter.generateCode());
        }
        if (shouldGenerateMetadata) {
            System.out.println("[+] Generate metadata");
            tmpFs.writeObject("j2py-generated-metadata.json", this.generateMetadata(mappedTypes));
        } else {
            System.out.println("[+] Skip metadata generation");
        }
        System.out.println("[+] Generate best effort list of Java sources (" + currentSourcePaths.size() + " files)");
        tmpFs.writeStringUTF8("java-source-paths.txt", currentSourcePaths.stream().map(RelFile::getFullPath).collect(Collectors.joining("\n")));
        long l = FSUtils.calculateSize(tmpFs, RelFile.root()) / 1024L;
        System.out.println("[+] Generate PY files: " + DKUtils.getElapsed((Stopwatch)sw) + " (" + l + "kB)");
        return tmpFs;
    }

    private static class MetadataFile {
        List<PyMappedType.PersistedTypeMeta> mappings = new ArrayList<PyMappedType.PersistedTypeMeta>();

        private MetadataFile() {
        }
    }
}

