/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.oauth;

import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.commons.CommonsHttpClient;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.http.HttpClient;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.oauth.AuthParameterPosition;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.oauth.RefreshableTokenSource;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.oauth.Token;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClientCredentials
extends RefreshableTokenSource {
    private HttpClient hc;
    private String clientId;
    private String clientSecret;
    private String tokenUrl;
    private Map<String, String> endpointParams;
    private List<String> scopes;
    private AuthParameterPosition position;

    private ClientCredentials(HttpClient hc, String clientId, String clientSecret, String tokenUrl, Map<String, String> endpointParams, List<String> scopes, AuthParameterPosition position) {
        this.hc = hc;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tokenUrl = tokenUrl;
        this.endpointParams = endpointParams;
        this.scopes = scopes;
        this.position = position;
    }

    @Override
    protected Token refresh() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "client_credentials");
        if (this.scopes != null) {
            params.put("scope", String.join((CharSequence)" ", this.scopes));
        }
        if (this.endpointParams != null) {
            params.putAll(this.endpointParams);
        }
        return ClientCredentials.retrieveToken(this.hc, this.clientId, this.clientSecret, this.tokenUrl, params, new HashMap<String, String>(), this.position);
    }

    public static class Builder {
        private String clientId;
        private String clientSecret;
        private String tokenUrl;
        private HttpClient hc = new CommonsHttpClient.Builder().withTimeoutSeconds(30).build();
        private Map<String, String> endpointParams = Collections.emptyMap();
        private List<String> scopes = Collections.emptyList();
        private AuthParameterPosition position = AuthParameterPosition.BODY;

        public Builder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder withTokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public Builder withEndpointParameters(Map<String, String> params) {
            this.endpointParams = params;
            return this;
        }

        public Builder withScopes(List<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder withAuthParameterPosition(AuthParameterPosition position) {
            this.position = position;
            return this;
        }

        public Builder withHttpClient(HttpClient hc) {
            this.hc = hc;
            return this;
        }

        public ClientCredentials build() {
            Objects.requireNonNull(this.clientId, "clientId must be specified");
            Objects.requireNonNull(this.clientSecret, "clientSecret must be specified");
            Objects.requireNonNull(this.tokenUrl, "tokenUrl must be specified");
            return new ClientCredentials(this.hc, this.clientId, this.clientSecret, this.tokenUrl, this.endpointParams, this.scopes, this.position);
        }
    }
}

