/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.types;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.types.BasePrimitiveType;
import io.delta.kernel.types.CollationIdentifier;

@Evolving
public class StringType
extends BasePrimitiveType {
    public static final StringType STRING = new StringType(CollationIdentifier.fromString("SPARK.UTF8_BINARY"));
    private final CollationIdentifier collationIdentifier;

    public StringType(CollationIdentifier collationIdentifier) {
        super("string");
        this.collationIdentifier = collationIdentifier;
    }

    public StringType(String string) {
        super("string");
        this.collationIdentifier = CollationIdentifier.fromString(string);
    }

    public CollationIdentifier getCollationIdentifier() {
        return this.collationIdentifier;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof StringType)) {
            return false;
        }
        StringType stringType = (StringType)object;
        return this.collationIdentifier.equals(stringType.collationIdentifier);
    }
}

