/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.lambda;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.directory.NodesDirectoryService;
import com.dataiku.dip.lambda.mgmt.LambdaMonitoringWizardService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.lambda.model.studioconfig.DeploymentMonitoringConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/api/lambda-services/monitoring"})
@Controller
public class LambdaMonitoringWizardController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private LambdaMonitoringWizardService lambdaMonitoringWizardService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private NodesDirectoryService nodesDirectoryService;

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    @ResponseBody
    public DeploymentMonitoringConfig createMonitoring(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String deploymentId, @RequestParam String endpointId) throws Exception {
        GeneralSettingsService.AppConfig appConfig;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            appConfig = this.generalSettingsService.getConfigurationInternal(req, resp);
        }
        if (!DKUApp.isDataikuCloud() && !appConfig.eventServerEnabled) {
            boolean hasExternalES;
            NodesDirectory nd = this.nodesDirectoryService.getNodesDirectoryUnsafe_AutoTXN();
            boolean bl = hasExternalES = nd.enabled && nd.hasEventServerNode() && !Objects.equals(nd.getCurrentNode().nodeId, nd.eventServerNodeId);
            if (hasExternalES) {
                throw new IllegalArgumentException("The Event Server is managed by Fleet Manager, and configured on another node: \"" + nd.eventServerNodeId + "\". Please configure the monitoring loop manually.");
            }
            throw new IllegalArgumentException("No Event Server has been enabled on your DSS instance. Please contact your administrator.");
        }
        return this.lambdaMonitoringWizardService.createMonitoring_NT(projectKey, deploymentId, endpointId, user);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, DeploymentMonitoringConfig> listMonitorings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam List<String> deploymentIds, @RequestParam String endpointId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            Map<String, DeploymentMonitoringConfig> map = deploymentIds.stream().map(deploymentId -> {
                try {
                    return this.lambdaMonitoringWizardService.getDeploymentMonitoringMandatoryUnsafe(projectKey, (String)deploymentId, endpointId, user);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toMap(DeploymentMonitoringConfig::getDeploymentId, Function.identity()));
            return map;
        }
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public void deleteMonitoring(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String deploymentId, @RequestParam String endpointId, @RequestParam boolean deleteObjects) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.lambdaMonitoringWizardService.deleteDeploymentMonitoringMandatoryUnsafe(projectKey, deploymentId, endpointId, deleteObjects, user);
            t.commit("Monitoring for deployment " + deploymentId + " deleted");
        }
    }
}

