/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.expr;

import java.util.Collection;

public class WordType
implements Comparable<WordType> {
    String stringRep;

    public WordType(String s) {
        this.stringRep = s;
    }

    public String toString() {
        return this.stringRep;
    }

    @Override
    public int compareTo(WordType t) {
        return this.stringRep.compareTo(t.stringRep);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof WordType)) {
            return false;
        }
        WordType t = (WordType)o;
        return this.stringRep.equals(t.stringRep);
    }

    public int hashCode() {
        return this.stringRep.hashCode();
    }

    public static void tokenize(String s, Collection<WordType> c) {
        if (s == null || s.length() == 0) {
            return;
        }
        int prec = 0;
        for (int i = 0; i < s.length(); ++i) {
            char currentChar = s.charAt(i);
            if (Character.isLetter(currentChar) || Character.isDigit(currentChar)) continue;
            if (prec != i) {
                c.add(new WordType(s.substring(prec, i)));
            }
            prec = i + 1;
        }
        if (prec != s.length()) {
            c.add(new WordType(s.substring(prec)));
        }
    }

    public static void blockTokenize(String s, Collection<WordType> c, int blockSize) {
        if (blockSize < 1) {
            return;
        }
        int length = s.length();
        for (int i = 0; i < length - blockSize + 1; ++i) {
            int j = i + blockSize;
            c.add(new WordType(s.substring(i, j)));
        }
    }

    public static int levenshtein(String s1, String s2) {
        int length1 = s1.length();
        int length2 = s2.length();
        if (s1.equals(s2)) {
            return 0;
        }
        if (length1 == 0) {
            return length2;
        }
        if (length2 == 0) {
            return length1;
        }
        int[] v0 = new int[length1 + 1];
        int[] v1 = new int[length1 + 1];
        for (int i = 0; i < length1 + 1; ++i) {
            v0[i] = i;
        }
        for (int k = 0; k < length2; ++k) {
            v1[0] = v0[0] + 1;
            for (int i = 1; i < length1 + 1; ++i) {
                int cost = s1.charAt(i - 1) == s2.charAt(k) ? 0 : 1;
                int min1 = Math.min(v0[i] + 1, v0[i - 1] + cost);
                v1[i] = Math.min(min1, v1[i - 1] + 1);
            }
            System.arraycopy(v1, 0, v0, 0, length1 + 1);
        }
        return v1[length1];
    }
}

