/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.utils.DKULoggerFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.intellij.lang.annotations.PrintFormat;

public class DKULogger {
    private final List<DKULoggerFilter> filters = new ArrayList<DKULoggerFilter>();
    private final Logger delegate;
    private static ThreadLocal<CallTime> tl = new ThreadLocal();

    public static DKULogger getLogger(String loggerName) {
        return new DKULogger(Logger.getLogger((String)loggerName));
    }

    public static DKULogger getLogger(Class c) {
        return new DKULogger(Logger.getLogger((Class)c));
    }

    public static Logger getRealLogger(String loggerName) {
        return Logger.getLogger((String)loggerName);
    }

    protected DKULogger(Logger innerLogger) {
        this.delegate = innerLogger;
    }

    public static void startCurrentCall() {
        if (tl.get() == null) {
            tl.set(new CallTime());
        }
        DKULogger.tl.get().start = System.currentTimeMillis();
    }

    public static long endCurrentCall() {
        if (tl.get() != null) {
            long start = DKULogger.tl.get().start;
            tl.remove();
            return System.currentTimeMillis() - start;
        }
        return 0L;
    }

    public static long getCurrentStartOrNow() {
        if (tl.get() != null) {
            return DKULogger.tl.get().start;
        }
        return System.currentTimeMillis();
    }

    public static void startCurrentCallWithExplicitStartTime(long start) {
        if (tl.get() == null) {
            tl.set(new CallTime());
        }
        DKULogger.tl.get().start = start;
    }

    private static Object concatTime(Object message) {
        if (tl.get() != null && DKULogger.tl.get().start != 0L) {
            String header = "[ct: " + (System.currentTimeMillis() - DKULogger.tl.get().start) + "]";
            return header + " " + String.valueOf(message);
        }
        return message;
    }

    public DKULogger addFilter(DKULoggerFilter filter) {
        this.filters.add(filter);
        return this;
    }

    public void addAppender(Appender appender) {
        this.delegate.addAppender(appender);
    }

    public boolean accept(Object message) {
        for (DKULoggerFilter filter : this.filters) {
            if (filter.accept(message)) continue;
            return false;
        }
        return true;
    }

    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled() && this.accept(message)) {
            this.delegate.debug(DKULogger.concatTime(message), t);
        }
    }

    public void debug(Object message) {
        if (this.isDebugEnabled() && this.accept(message)) {
            this.delegate.debug(DKULogger.concatTime(message));
        }
    }

    public void debugV(@PrintFormat String message, Object ... format) {
        if (this.isDebugEnabled()) {
            this.debug(String.format(message, format));
        }
    }

    public void debugV(Throwable t, String message, Object ... format) {
        this.debug(String.format(message, format), t);
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public void error(Object message, Throwable t) {
        if (this.accept(message)) {
            this.delegate.error(message, t);
        }
    }

    public void error(Object message) {
        if (this.accept(message)) {
            this.delegate.error(message);
        }
    }

    public void errorV(@PrintFormat String message, Object ... format) {
        this.error(String.format(message, format));
    }

    public void errorV(Throwable t, @PrintFormat String message, Object ... format) {
        this.error(String.format(message, format), t);
    }

    public void fatal(Object message, Throwable t) {
        if (this.accept(message)) {
            this.delegate.fatal(message, t);
        }
    }

    public void fatal(Object message) {
        if (this.accept(message)) {
            this.delegate.fatal(message);
        }
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public void info(Object message, Throwable t) {
        if (this.isInfoEnabled() && this.accept(message)) {
            this.delegate.info(DKULogger.concatTime(message), t);
        }
    }

    public void info(Object message) {
        if (this.isInfoEnabled() && this.accept(message)) {
            this.delegate.info(DKULogger.concatTime(message));
        }
    }

    public void infoV(@PrintFormat String message, Object ... format) {
        if (this.isInfoEnabled()) {
            this.info(String.format(message, format));
        }
    }

    public void infoV(Throwable t, @PrintFormat String message, Object ... format) {
        if (this.isInfoEnabled()) {
            this.info(String.format(message, format), t);
        }
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public boolean isEnabledFor(Priority level) {
        return this.delegate.isEnabledFor(level);
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.delegate.isEnabledFor(Priority.WARN);
    }

    public void log(Priority priority, Object message, Throwable t) {
        if (this.isEnabledFor(priority) && this.accept(message)) {
            this.delegate.log(priority, message, t);
        }
    }

    public void log(Priority priority, Object message) {
        if (this.isEnabledFor(priority) && this.accept(message)) {
            this.delegate.log(priority, message);
        }
    }

    public void log(String callerFQCN, Priority level, Object message, Throwable t) {
        if (this.isEnabledFor(level) && this.accept(message)) {
            this.delegate.log(callerFQCN, level, message, t);
        }
    }

    public void setAdditivity(boolean additive) {
        this.delegate.setAdditivity(additive);
    }

    public void setLevel(Level level) {
        this.delegate.setLevel(level);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void trace(Supplier<Object> messageSupplier, Throwable t) {
        Object message;
        if (this.isTraceEnabled() && this.accept(message = messageSupplier.get())) {
            this.delegate.trace(message, t);
        }
    }

    public void trace(Supplier<Object> messageSupplier) {
        Object message;
        if (this.isTraceEnabled() && this.accept(message = messageSupplier.get())) {
            this.delegate.trace(message);
        }
    }

    public void debug(Supplier<Object> messageSupplier, Throwable t) {
        Object message;
        if (this.isDebugEnabled() && this.accept(message = messageSupplier.get())) {
            this.delegate.debug(message, t);
        }
    }

    public void debug(Supplier<Object> messageSupplier) {
        Object message;
        if (this.isDebugEnabled() && this.accept(message = messageSupplier.get())) {
            this.delegate.debug(message);
        }
    }

    public void trace(Object message, Throwable t) {
        this.trace(() -> message, t);
    }

    public void trace(Object message) {
        this.trace(() -> message);
    }

    public void traceV(@PrintFormat String message, Object ... format) {
        this.trace(() -> String.format(message, format));
    }

    public void traceV(Throwable t, @PrintFormat String message, Object ... format) {
        this.trace(() -> String.format(message, format), t);
    }

    public void warn(Object message, Throwable t) {
        if (this.isWarnEnabled() && this.accept(message)) {
            this.delegate.warn(message, t);
        }
    }

    public void warn(Object message) {
        if (this.isWarnEnabled() && this.accept(message)) {
            this.delegate.warn(message);
        }
    }

    public void warnV(@PrintFormat String message, Object ... format) {
        if (this.isWarnEnabled()) {
            this.warn(String.format(message, format));
        }
    }

    public void warnV(Throwable t, @PrintFormat String message, Object ... format) {
        if (this.isWarnEnabled()) {
            this.warn(String.format(message, format), t);
        }
    }

    private static class CallTime {
        long start;

        private CallTime() {
        }
    }
}

