/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.output;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.input.formats.BasicCSVFormatConfig;
import com.dataiku.dip.output.StringOutputFormatter;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.WithParams;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BasicCSVOutputFormatter
extends StringOutputFormatter {
    BasicCSVFormatConfig config;
    private Schema outputSchema;
    private char delimiter;
    private boolean printHeaderLine;
    private boolean prefixHeaderLineWithSharp;
    private List<Column> headerColumns = new ArrayList<Column>();
    private List<Type> columnTypes = new ArrayList<Type>();

    public BasicCSVOutputFormatter(WithParams p) {
        super(p.getParam("charset", "utf8"));
        this.config = new BasicCSVFormatConfig(p);
        this.delimiter = this.config.separator;
        this.printHeaderLine = this.config.parseHeaderRow;
        this.prefixHeaderLineWithSharp = p.getBoolParam("prefixHeaderLineWithSharp", false);
    }

    @Override
    public void setOutputSchema(Schema schema) {
        this.outputSchema = schema;
    }

    @Override
    public void header(ColumnFactory cf, Writer sb) throws IOException {
        if (this.printHeaderLine && this.prefixHeaderLineWithSharp) {
            sb.append("# ");
        }
        if (this.outputSchema != null) {
            for (int i = 0; i < this.outputSchema.getColumns().size(); ++i) {
                String name = this.outputSchema.getColumns().get(i).getName();
                if (i > 0 && this.printHeaderLine) {
                    sb.append(this.delimiter);
                }
                this.headerColumns.add(cf.column(name));
                Type type = this.outputSchema.getColumns().get(i).getType();
                this.columnTypes.add(type);
                if (!this.printHeaderLine) continue;
                sb.append(name);
            }
        } else {
            int i = 0;
            for (Column c : cf.columns()) {
                this.headerColumns.add(c);
                this.columnTypes.add(Type.STRING);
                if (i++ > 0 && this.printHeaderLine) {
                    sb.append(this.delimiter);
                }
                if (!this.printHeaderLine) continue;
                sb.append(c.getName());
            }
        }
        if (this.printHeaderLine) {
            sb.append('\n');
        }
    }

    @Override
    public void format(Row row, ColumnFactory cf, Writer sb) throws IOException {
        int i = 0;
        for (Column c : this.headerColumns) {
            String v = row.get(c);
            Type type = this.columnTypes.get(i);
            if (i++ > 0) {
                sb.append(this.delimiter);
            }
            if (!type.isPrimitive()) {
                if (this.config.arrayMapFormat.equals("json")) {
                    BasicCSVOutputFormatter.appendUNIXStyle(sb, v, this.delimiter, this.config.quoteChar, this.config.escapeChar);
                    continue;
                }
                if (type == Type.MAP) {
                    BasicCSVOutputFormatter.appendMapDelimited(sb, v, this.delimiter, this.config.quoteChar, this.config.escapeChar, this.config.arraySeparator.charValue(), this.config.mapKeySeparator.charValue());
                    continue;
                }
                if (type == Type.ARRAY) {
                    BasicCSVOutputFormatter.appendArrayDelimited(sb, v, this.delimiter, this.config.quoteChar, this.config.escapeChar, this.config.arraySeparator.charValue(), this.config.mapKeySeparator.charValue());
                    continue;
                }
                throw ErrorContext.iae((String)("Unknown non-primitive type " + String.valueOf((Object)type)));
            }
            BasicCSVOutputFormatter.appendUNIXStyle(sb, v, this.delimiter, this.config.quoteChar, this.config.escapeChar);
        }
        sb.append('\n');
    }

    @Override
    public void footer(ColumnFactory cf, Writer sb) throws IOException {
    }

    @Override
    public void cancel(OutputStream os) throws Exception {
    }

    public static void appendMapDelimited(Writer wr, String v, char sep, char quote, Character escape, char arraySeparator, char mapKeySeparator) throws IOException {
        try {
            JSONObject obj = new JSONObject(v);
            Iterator it = obj.keys();
            int i = 0;
            StringBuilder sb = new StringBuilder();
            boolean shouldQuote = false;
            while (it.hasNext()) {
                String value;
                String key = (String)it.next();
                Object oval = obj.get(key);
                String string = value = oval == null ? null : oval.toString();
                if (i++ > 0) {
                    sb.append(arraySeparator);
                }
                shouldQuote |= BasicCSVOutputFormatter.appendEscaped(sb, key, sep, quote, escape);
                sb.append(mapKeySeparator);
                shouldQuote |= BasicCSVOutputFormatter.appendEscaped(sb, value, sep, quote, escape);
            }
            if (shouldQuote) {
                wr.write(quote);
                wr.write(sb.toString());
                wr.write(quote);
            } else {
                wr.write(sb.toString());
            }
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    public static void appendArrayDelimited(Writer wr, String v, char sep, char quote, Character escape, char arraySeparator, char mapKeySeparator) throws IOException {
        try {
            JSONArray obj = new JSONArray(v);
            int length = obj.length();
            StringBuilder sb = new StringBuilder();
            boolean shouldQuote = false;
            for (int i = 0; i < length; ++i) {
                String value;
                Object oval = obj.get(i);
                String string = value = oval == null ? null : oval.toString();
                if (i > 0) {
                    sb.append(arraySeparator);
                }
                shouldQuote |= BasicCSVOutputFormatter.appendEscaped(sb, value, sep, quote, escape);
            }
            if (shouldQuote) {
                wr.write(quote);
                wr.write(sb.toString());
                wr.write(quote);
            } else {
                wr.write(sb.toString());
            }
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    public static boolean appendEscaped(StringBuilder sb, String v, char sep, char quote, Character escape) {
        if (v != null && v.length() > 0) {
            if (StringUtils.contains((String)v, (char)sep) || StringUtils.contains((String)v, (char)quote) || StringUtils.contains((String)v, (char)'\n') || StringUtils.contains((String)v, (char)'\r')) {
                if (escape != null) {
                    sb.append(StringUtils.replace((String)v, (String)("" + quote), (String)("" + escape + quote)));
                } else {
                    sb.append(v);
                }
                return true;
            }
            sb.append(v);
            return false;
        }
        return false;
    }

    public static void appendUNIXStyle(Writer wr, String v, char sep, char quote, Character escape) throws IOException {
        if (v != null && v.length() > 0) {
            if (StringUtils.contains((String)v, (char)sep) || StringUtils.contains((String)v, (char)quote) || StringUtils.contains((String)v, (char)'\n') || StringUtils.contains((String)v, (char)'\r') || escape != null && StringUtils.contains((String)v, (char)escape.charValue())) {
                wr.append(quote);
                if (escape != null) {
                    String e = StringUtils.replace((String)v, (String)("" + escape), (String)("" + escape + escape));
                    e = StringUtils.replace((String)e, (String)("" + quote), (String)("" + escape + quote));
                    wr.append(e);
                } else {
                    wr.append(v);
                }
                wr.append(quote);
            } else {
                wr.append(v);
            }
        }
    }
}

