/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.jose.crypto;

import com.dataiku.dss.shadelib.com.nimbusds.jose.JOSEException;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JWEAlgorithm;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JWECryptoParts;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JWEEncrypter;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JWEHeader;
import com.dataiku.dss.shadelib.com.nimbusds.jose.KeyLengthException;
import com.dataiku.dss.shadelib.com.nimbusds.jose.crypto.impl.AAD;
import com.dataiku.dss.shadelib.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import com.dataiku.dss.shadelib.com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import com.dataiku.dss.shadelib.com.nimbusds.jose.crypto.impl.DirectCryptoProvider;
import com.dataiku.dss.shadelib.com.nimbusds.jose.crypto.impl.JWEHeaderValidation;
import com.dataiku.dss.shadelib.com.nimbusds.jose.jwk.OctetSequenceKey;
import com.dataiku.dss.shadelib.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import com.dataiku.dss.shadelib.com.nimbusds.jose.util.Base64URL;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

@ThreadSafe
public class DirectEncrypter
extends DirectCryptoProvider
implements JWEEncrypter {
    public DirectEncrypter(SecretKey key) throws KeyLengthException {
        super(key);
    }

    public DirectEncrypter(byte[] keyBytes) throws KeyLengthException {
        this(new SecretKeySpec(keyBytes, "AES"));
    }

    public DirectEncrypter(OctetSequenceKey octJWK) throws KeyLengthException {
        this(octJWK.toSecretKey("AES"));
    }

    @Deprecated
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText) throws JOSEException {
        return this.encrypt(header, clearText, AAD.compute(header));
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText, byte[] aad) throws JOSEException {
        JWEAlgorithm alg = JWEHeaderValidation.getAlgorithmAndEnsureNotNull(header);
        if (!alg.equals(JWEAlgorithm.DIR)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(alg, SUPPORTED_ALGORITHMS));
        }
        Base64URL encryptedKey = null;
        return ContentCryptoProvider.encrypt(header, clearText, aad, this.getKey(), encryptedKey, this.getJCAContext());
    }
}

