/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.dpop.verifiers;

import com.dataiku.dss.shadelib.com.nimbusds.jose.JOSEException;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JWSAlgorithm;
import com.dataiku.dss.shadelib.com.nimbusds.jose.KeySourceException;
import com.dataiku.dss.shadelib.com.nimbusds.jose.proc.BadJOSEException;
import com.dataiku.dss.shadelib.com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.dataiku.dss.shadelib.com.nimbusds.jose.util.Base64URL;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.SignedJWT;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.dpop.DPoPProofFactory;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.dpop.DPoPUtils;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.dpop.JWKThumbprintConfirmation;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.dpop.verifiers.AccessTokenValidationException;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPIssuer;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPKeySelector;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPProofClaimsSetVerifier;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPProofContext;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.dpop.verifiers.InvalidDPoPProofException;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.JWTID;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.token.DPoPAccessToken;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.StringUtils;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.URIUtils;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.singleuse.SingleUseChecker;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.Nonce;
import com.dataiku.dss.shadelib.net.jcip.annotations.ThreadSafe;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@ThreadSafe
class DPoPCommonVerifier {
    public static final Set<JWSAlgorithm> SUPPORTED_JWS_ALGORITHMS;
    private final Set<JWSAlgorithm> acceptedJWSAlgs;
    private final long maxClockSkewSeconds;
    private final SingleUseChecker<Map.Entry<DPoPIssuer, JWTID>> singleUseChecker;

    DPoPCommonVerifier(Set<JWSAlgorithm> acceptedJWSAlgs, long maxClockSkewSeconds, SingleUseChecker<Map.Entry<DPoPIssuer, JWTID>> singleUseChecker) {
        if (!SUPPORTED_JWS_ALGORITHMS.containsAll(acceptedJWSAlgs)) {
            throw new IllegalArgumentException("Unsupported JWS algorithms: " + acceptedJWSAlgs.retainAll(SUPPORTED_JWS_ALGORITHMS));
        }
        this.acceptedJWSAlgs = acceptedJWSAlgs;
        this.maxClockSkewSeconds = maxClockSkewSeconds;
        this.singleUseChecker = singleUseChecker;
    }

    void verify(String method, URI uri, DPoPIssuer issuer, SignedJWT proof, DPoPAccessToken accessToken, JWKThumbprintConfirmation cnf, Nonce nonce) throws InvalidDPoPProofException, AccessTokenValidationException, JOSEException {
        if (StringUtils.isBlank(method)) {
            throw new IllegalArgumentException("The HTTP request method must not be null or blank");
        }
        if (uri == null) {
            throw new IllegalArgumentException("The HTTP URI must not be null");
        }
        DefaultJWTProcessor proc = new DefaultJWTProcessor();
        proc.setJWSTypeVerifier(new DefaultJOSEObjectTypeVerifier(DPoPProofFactory.TYPE));
        proc.setJWSKeySelector(new DPoPKeySelector(this.acceptedJWSAlgs));
        proc.setJWTClaimsSetVerifier(new DPoPProofClaimsSetVerifier(URIUtils.getBaseURI(uri), method, nonce, this.maxClockSkewSeconds, accessToken != null, this.singleUseChecker));
        DPoPProofContext context = new DPoPProofContext(issuer);
        try {
            proc.process(proof, context);
        }
        catch (KeySourceException | BadJOSEException e) {
            throw new InvalidDPoPProofException("Invalid DPoP proof: " + e.getMessage(), e);
        }
        if (accessToken != null) {
            Base64URL accessTokenHash = DPoPUtils.computeSHA256(accessToken);
            if (!context.getAccessTokenHash().equals(accessTokenHash)) {
                throw new AccessTokenValidationException("The access token hash doesn't match the JWT ath claim");
            }
            if (!proof.getHeader().getJWK().computeThumbprint().equals(cnf.getValue())) {
                throw new AccessTokenValidationException("The DPoP proof JWK doesn't match the JWK SHA-256 thumbprint confirmation");
            }
        }
    }

    static {
        HashSet<JWSAlgorithm> supported = new HashSet<JWSAlgorithm>();
        supported.addAll(JWSAlgorithm.Family.EC);
        supported.addAll(JWSAlgorithm.Family.RSA);
        SUPPORTED_JWS_ALGORITHMS = Collections.unmodifiableSet(supported);
    }
}

