/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.io.swagger.util;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.io.swagger.annotations.Extension;
import com.dataiku.dss.shadelib.io.swagger.annotations.ExtensionProperty;
import com.dataiku.dss.shadelib.io.swagger.util.Json;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import java.util.HashMap;
import java.util.Map;

public final class BaseReaderUtils {
    private BaseReaderUtils() {
    }

    public static Map<String, Object> parseExtensions(Extension[] extensions) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Extension extension : extensions) {
            String name = extension.name();
            String key = name.length() > 0 ? StringUtils.prependIfMissing(name, "x-", new CharSequence[0]) : name;
            for (ExtensionProperty property : extension.properties()) {
                String propertyName = property.name();
                String propertyValue = property.value();
                JsonNode processedValue = null;
                boolean propertyAsJson = property.parseValue();
                if (!StringUtils.isNotBlank(propertyName) || !StringUtils.isNotBlank(propertyValue)) continue;
                if (key.isEmpty()) {
                    if (propertyAsJson) {
                        try {
                            processedValue = Json.mapper().readTree(propertyValue);
                            map.put(StringUtils.prependIfMissing(propertyName, "x-", new CharSequence[0]), processedValue);
                        }
                        catch (Exception e) {
                            map.put(StringUtils.prependIfMissing(propertyName, "x-", new CharSequence[0]), propertyValue);
                        }
                        continue;
                    }
                    map.put(StringUtils.prependIfMissing(propertyName, "x-", new CharSequence[0]), propertyValue);
                    continue;
                }
                Object value = map.get(key);
                if (value == null || !(value instanceof Map)) {
                    value = new HashMap();
                    map.put(key, value);
                }
                Map mapValue = (Map)value;
                if (propertyAsJson) {
                    try {
                        processedValue = Json.mapper().readTree(propertyValue);
                        mapValue.put(propertyName, processedValue);
                    }
                    catch (Exception e) {
                        mapValue.put(propertyName, propertyValue);
                    }
                    continue;
                }
                mapValue.put(propertyName, propertyValue);
            }
        }
        return map;
    }
}

