/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queries.function.valuesource;

import com.dataiku.dss.shadelib.org.apache.lucene.index.FieldInfo;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.VectorEncoding;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.FunctionValues;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.ValueSource;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DocIdSetIterator;
import java.io.IOException;

public abstract class VectorFieldFunction
extends FunctionValues {
    protected final ValueSource valueSource;
    int lastDocID;

    protected VectorFieldFunction(ValueSource valueSource) {
        this.valueSource = valueSource;
    }

    protected abstract DocIdSetIterator getVectorIterator();

    @Override
    public String toString(int doc) throws IOException {
        return this.valueSource.description() + this.strVal(doc);
    }

    @Override
    public boolean exists(int doc) throws IOException {
        if (doc < this.lastDocID) {
            throw new IllegalArgumentException("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs docID=" + doc);
        }
        this.lastDocID = doc;
        int curDocID = this.getVectorIterator().docID();
        if (doc > curDocID) {
            curDocID = this.getVectorIterator().advance(doc);
        }
        return doc == curDocID;
    }

    static void checkField(LeafReader in, String field, VectorEncoding expectedEncoding) {
        FieldInfo fi = in.getFieldInfos().fieldInfo(field);
        if (fi != null) {
            VectorEncoding actual;
            VectorEncoding vectorEncoding = actual = fi.hasVectorValues() ? fi.getVectorEncoding() : null;
            if (expectedEncoding != actual) {
                throw new IllegalStateException("Unexpected vector encoding (" + actual + ") for field " + field + "(expected=" + expectedEncoding + ")");
            }
        }
    }
}

