/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search;

import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BoostQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BulkScorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ConstantScoreScorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ConstantScoreWeight;
import com.dataiku.dss.shadelib.org.apache.lucene.search.FilterLeafCollector;
import com.dataiku.dss.shadelib.org.apache.lucene.search.FilterScorable;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.LeafCollector;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MatchNoDocsQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Matches;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.QueryVisitor;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Scorable;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScoreMode;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Scorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScorerSupplier;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TwoPhaseIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Weight;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Bits;
import java.io.IOException;
import java.util.Objects;

public final class ConstantScoreQuery
extends Query {
    private final Query query;

    public ConstantScoreQuery(Query query) {
        this.query = Objects.requireNonNull(query, "Query must not be null");
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query rewritten = this.query.rewrite(indexSearcher);
        if (rewritten instanceof BoostQuery) {
            rewritten = ((BoostQuery)rewritten).getQuery();
        } else if (rewritten instanceof ConstantScoreQuery) {
            rewritten = ((ConstantScoreQuery)rewritten).getQuery();
        } else if (rewritten instanceof BooleanQuery) {
            rewritten = ((BooleanQuery)rewritten).rewriteNoScoring();
        }
        if (rewritten.getClass() == MatchNoDocsQuery.class) {
            return rewritten;
        }
        if (rewritten != this.query) {
            return new ConstantScoreQuery(rewritten);
        }
        if (rewritten.getClass() == ConstantScoreQuery.class) {
            return rewritten;
        }
        if (rewritten.getClass() == BoostQuery.class) {
            return new ConstantScoreQuery(((BoostQuery)rewritten).getQuery());
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.query.visit(visitor.getSubVisitor(BooleanClause.Occur.FILTER, this));
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        ScoreMode innerScoreMode = scoreMode.isExhaustive() ? ScoreMode.COMPLETE_NO_SCORES : ScoreMode.TOP_DOCS;
        final Weight innerWeight = searcher.createWeight(this.query, innerScoreMode, 1.0f);
        if (scoreMode.needsScores()) {
            return new ConstantScoreWeight(this, boost){

                @Override
                public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                    if (!scoreMode.isExhaustive()) {
                        return super.bulkScorer(context);
                    }
                    BulkScorer innerScorer = innerWeight.bulkScorer(context);
                    if (innerScorer == null) {
                        return null;
                    }
                    return new ConstantBulkScorer(innerScorer, this, this.score());
                }

                @Override
                public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                    final ScorerSupplier innerScorerSupplier = innerWeight.scorerSupplier(context);
                    if (innerScorerSupplier == null) {
                        return null;
                    }
                    return new ScorerSupplier(){

                        @Override
                        public Scorer get(long leadCost) throws IOException {
                            Scorer innerScorer = innerScorerSupplier.get(leadCost);
                            TwoPhaseIterator twoPhaseIterator = innerScorer.twoPhaseIterator();
                            if (twoPhaseIterator == null) {
                                return new ConstantScoreScorer(innerWeight, this.score(), scoreMode, innerScorer.iterator());
                            }
                            return new ConstantScoreScorer(innerWeight, this.score(), scoreMode, twoPhaseIterator);
                        }

                        @Override
                        public long cost() {
                            return innerScorerSupplier.cost();
                        }
                    };
                }

                @Override
                public Matches matches(LeafReaderContext context, int doc) throws IOException {
                    return innerWeight.matches(context, doc);
                }

                @Override
                public Scorer scorer(LeafReaderContext context) throws IOException {
                    ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                    if (scorerSupplier == null) {
                        return null;
                    }
                    return scorerSupplier.get(Long.MAX_VALUE);
                }

                @Override
                public boolean isCacheable(LeafReaderContext ctx) {
                    return innerWeight.isCacheable(ctx);
                }

                @Override
                public int count(LeafReaderContext context) throws IOException {
                    return innerWeight.count(context);
                }
            };
        }
        return innerWeight;
    }

    @Override
    public String toString(String field) {
        return "ConstantScore(" + this.query.toString(field) + ')';
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.query.equals(((ConstantScoreQuery)other).query);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + this.query.hashCode();
    }

    protected static class ConstantBulkScorer
    extends BulkScorer {
        final BulkScorer bulkScorer;
        final Weight weight;
        final float theScore;

        public ConstantBulkScorer(BulkScorer bulkScorer, Weight weight, float theScore) {
            this.bulkScorer = bulkScorer;
            this.weight = weight;
            this.theScore = theScore;
        }

        @Override
        public int score(LeafCollector collector, Bits acceptDocs, int min2, int max) throws IOException {
            return this.bulkScorer.score(this.wrapCollector(collector), acceptDocs, min2, max);
        }

        private LeafCollector wrapCollector(LeafCollector collector) {
            return new FilterLeafCollector(collector){

                @Override
                public void setScorer(Scorable scorer) throws IOException {
                    this.in.setScorer(new FilterScorable(scorer){

                        @Override
                        public float score() {
                            return theScore;
                        }
                    });
                }
            };
        }

        @Override
        public long cost() {
            return this.bulkScorer.cost();
        }
    }
}

