/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search;

import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BulkScorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ConstantScoreScorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ConstantScoreWeight;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DocIdSetIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.LeafCollector;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.QueryVisitor;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScoreAndDoc;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScoreMode;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Scorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Weight;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Bits;
import java.io.IOException;

public final class MatchAllDocsQuery
extends Query {
    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) {
        return new ConstantScoreWeight(this, boost){

            public String toString() {
                return "weight(" + MatchAllDocsQuery.this + ")";
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, DocIdSetIterator.all(context.reader().maxDoc()));
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                if (!scoreMode.isExhaustive()) {
                    return super.bulkScorer(context);
                }
                final float score = this.score();
                final int maxDoc = context.reader().maxDoc();
                return new BulkScorer(){

                    @Override
                    public int score(LeafCollector collector, Bits acceptDocs, int min2, int max) throws IOException {
                        max = Math.min(max, maxDoc);
                        ScoreAndDoc scorer = new ScoreAndDoc();
                        scorer.score = score;
                        collector.setScorer(scorer);
                        for (int doc = min2; doc < max; ++doc) {
                            scorer.doc = doc;
                            if (acceptDocs != null && !acceptDocs.get(doc)) continue;
                            collector.collect(doc);
                        }
                        return max == maxDoc ? Integer.MAX_VALUE : max;
                    }

                    @Override
                    public long cost() {
                        return maxDoc;
                    }
                };
            }

            @Override
            public int count(LeafReaderContext context) {
                return context.reader().numDocs();
            }
        };
    }

    @Override
    public String toString(String field) {
        return "*:*";
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o);
    }

    @Override
    public int hashCode() {
        return this.classHash();
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }
}

