/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search;

import com.dataiku.dss.shadelib.org.apache.lucene.index.ImpactsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.index.PostingsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SlowImpactsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermState;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermStates;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Terms;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.internal.hppc.IntArrayList;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ExactPhraseMatcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MatchNoDocsQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.PhraseMatcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.PhraseQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.PhraseWeight;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.QueryVisitor;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScoreMode;
import com.dataiku.dss.shadelib.org.apache.lucene.search.SloppyPhraseMatcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermStatistics;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Weight;
import com.dataiku.dss.shadelib.org.apache.lucene.search.similarities.Similarity;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ArrayUtil;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import com.dataiku.dss.shadelib.org.apache.lucene.util.PriorityQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class MultiPhraseQuery
extends Query {
    private final String field;
    private final Term[][] termArrays;
    private final int[] positions;
    private final int slop;

    private MultiPhraseQuery(String field, Term[][] termArrays, int[] positions, int slop) {
        this.field = field;
        this.termArrays = termArrays;
        this.positions = positions;
        this.slop = slop;
    }

    public int getSlop() {
        return this.slop;
    }

    public Term[][] getTermArrays() {
        return this.termArrays;
    }

    public int[] getPositions() {
        return this.positions;
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.termArrays.length == 0) {
            return new MatchNoDocsQuery("empty MultiPhraseQuery");
        }
        if (this.termArrays.length == 1) {
            Term[] terms = this.termArrays[0];
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (Term term : terms) {
                builder.add(new TermQuery(term), BooleanClause.Occur.SHOULD);
            }
            return builder.build();
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (!visitor.acceptField(this.field)) {
            return;
        }
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.MUST, this);
        for (Term[] terms : this.termArrays) {
            QueryVisitor sv = v.getSubVisitor(BooleanClause.Occur.SHOULD, this);
            sv.consumeTerms(this, terms);
        }
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, final float boost) throws IOException {
        final HashMap termStates = new HashMap();
        return new PhraseWeight(this, this.field, searcher, scoreMode){

            @Override
            protected Similarity.SimScorer getStats(IndexSearcher searcher) throws IOException {
                ArrayList<TermStatistics> allTermStats = new ArrayList<TermStatistics>();
                Term[][] termArray = MultiPhraseQuery.this.termArrays;
                int n = termArray.length;
                for (int i = 0; i < n; ++i) {
                    Term[] terms;
                    for (Term term : terms = termArray[i]) {
                        TermStates ts = (TermStates)termStates.get(term);
                        if (ts == null) {
                            ts = TermStates.build(searcher, term, this.scoreMode.needsScores());
                            termStates.put(term, ts);
                        }
                        if (!this.scoreMode.needsScores() || ts.docFreq() <= 0) continue;
                        allTermStats.add(searcher.termStatistics(term, ts.docFreq(), ts.totalTermFreq()));
                    }
                }
                if (allTermStats.isEmpty()) {
                    return null;
                }
                return this.similarity.scorer(boost, searcher.collectionStatistics(this.field), allTermStats.toArray(new TermStatistics[allTermStats.size()]));
            }

            @Override
            protected PhraseMatcher getPhraseMatcher(LeafReaderContext context, Similarity.SimScorer scorer, boolean exposeOffsets) throws IOException {
                assert (MultiPhraseQuery.this.termArrays.length != 0);
                LeafReader reader = context.reader();
                Comparable[] postingsFreqs = new PhraseQuery.PostingsAndFreq[MultiPhraseQuery.this.termArrays.length];
                Terms fieldTerms = reader.terms(this.field);
                if (fieldTerms == null) {
                    return null;
                }
                if (!fieldTerms.hasPositions()) {
                    throw new IllegalStateException("field \"" + this.field + "\" was indexed without position data; cannot run MultiPhraseQuery (phrase=" + this.getQuery() + ")");
                }
                TermsEnum termsEnum = fieldTerms.iterator();
                float totalMatchCost = 0.0f;
                for (int pos = 0; pos < postingsFreqs.length; ++pos) {
                    Term[] terms = MultiPhraseQuery.this.termArrays[pos];
                    ArrayList<PostingsEnum> postings = new ArrayList<PostingsEnum>();
                    for (Term term : terms) {
                        TermState termState = ((TermStates)termStates.get(term)).get(context);
                        if (termState == null) continue;
                        termsEnum.seekExact(term.bytes(), termState);
                        postings.add(termsEnum.postings(null, exposeOffsets ? 120 : 24));
                        totalMatchCost += PhraseQuery.termPositionsCost(termsEnum);
                    }
                    if (postings.isEmpty()) {
                        return null;
                    }
                    PostingsEnum postingsEnum = postings.size() == 1 ? (PostingsEnum)postings.get(0) : (exposeOffsets ? new UnionFullPostingsEnum((List<PostingsEnum>)postings) : new UnionPostingsEnum(postings));
                    postingsFreqs[pos] = new PhraseQuery.PostingsAndFreq(postingsEnum, (ImpactsEnum)new SlowImpactsEnum(postingsEnum), MultiPhraseQuery.this.positions[pos], terms);
                }
                if (MultiPhraseQuery.this.slop == 0) {
                    ArrayUtil.timSort((Comparable[])postingsFreqs);
                    return new ExactPhraseMatcher((PhraseQuery.PostingsAndFreq[])postingsFreqs, this.scoreMode, scorer, totalMatchCost);
                }
                return new SloppyPhraseMatcher((PhraseQuery.PostingsAndFreq[])postingsFreqs, MultiPhraseQuery.this.slop, this.scoreMode, scorer, totalMatchCost, exposeOffsets);
            }
        };
    }

    @Override
    public final String toString(String f) {
        StringBuilder buffer = new StringBuilder();
        if (this.field == null || !this.field.equals(f)) {
            buffer.append(this.field);
            buffer.append(":");
        }
        buffer.append("\"");
        int lastPos = -1;
        for (int i = 0; i < this.termArrays.length; ++i) {
            int j;
            Term[] terms = this.termArrays[i];
            int position = this.positions[i];
            if (i != 0) {
                buffer.append(" ");
                for (j = 1; j < position - lastPos; ++j) {
                    buffer.append("? ");
                }
            }
            if (terms.length > 1) {
                buffer.append("(");
                for (j = 0; j < terms.length; ++j) {
                    buffer.append(terms[j].text());
                    if (j >= terms.length - 1) continue;
                    buffer.append(" ");
                }
                buffer.append(")");
            } else {
                buffer.append(terms[0].text());
            }
            lastPos = position;
        }
        buffer.append("\"");
        if (this.slop != 0) {
            buffer.append("~");
            buffer.append(this.slop);
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((MultiPhraseQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(MultiPhraseQuery other) {
        return this.slop == other.slop && this.termArraysEquals(this.termArrays, other.termArrays) && Arrays.equals(this.positions, other.positions);
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.slop ^ this.termArraysHashCode() ^ Arrays.hashCode(this.positions);
    }

    private int termArraysHashCode() {
        int hashCode = 1;
        for (Object[] objectArray : this.termArrays) {
            hashCode = 31 * hashCode + (objectArray == null ? 0 : Arrays.hashCode(objectArray));
        }
        return hashCode;
    }

    private boolean termArraysEquals(Term[][] termArrays1, Term[][] termArrays2) {
        if (termArrays1.length != termArrays2.length) {
            return false;
        }
        for (int i = 0; i < termArrays1.length; ++i) {
            Object[] termArray1 = termArrays1[i];
            Object[] termArray2 = termArrays2[i];
            if (termArray1 != null ? Arrays.equals(termArray1, termArray2) : termArray2 == null) continue;
            return false;
        }
        return true;
    }

    public static class UnionFullPostingsEnum
    extends UnionPostingsEnum {
        int freq = -1;
        boolean started = false;
        final PriorityQueue<PostingsAndPosition> posQueue;
        final Collection<PostingsAndPosition> subs;

        public UnionFullPostingsEnum(List<PostingsEnum> subs) {
            super(subs);
            this.posQueue = new PriorityQueue<PostingsAndPosition>(subs.size()){

                @Override
                protected boolean lessThan(PostingsAndPosition a, PostingsAndPosition b) {
                    return a.pos < b.pos;
                }
            };
            this.subs = new ArrayList<PostingsAndPosition>();
            for (PostingsEnum pe : subs) {
                this.subs.add(new PostingsAndPosition(pe));
            }
        }

        @Override
        public int freq() throws IOException {
            int doc = this.docID();
            if (doc == this.posQueueDoc) {
                return this.freq;
            }
            this.freq = 0;
            this.started = false;
            this.posQueue.clear();
            for (PostingsAndPosition pp : this.subs) {
                if (pp.pe.docID() != doc) continue;
                pp.pos = pp.pe.nextPosition();
                pp.upto = pp.pe.freq();
                this.posQueue.add(pp);
                this.freq += pp.upto;
            }
            return this.freq;
        }

        @Override
        public int nextPosition() throws IOException {
            if (!this.started) {
                this.started = true;
                return this.posQueue.top().pos;
            }
            if (this.posQueue.top().upto == 1) {
                this.posQueue.pop();
                return this.posQueue.top().pos;
            }
            this.posQueue.top().pos = this.posQueue.top().pe.nextPosition();
            --this.posQueue.top().upto;
            this.posQueue.updateTop();
            return this.posQueue.top().pos;
        }

        @Override
        public int startOffset() throws IOException {
            return this.posQueue.top().pe.startOffset();
        }

        @Override
        public int endOffset() throws IOException {
            return this.posQueue.top().pe.endOffset();
        }

        @Override
        public BytesRef getPayload() throws IOException {
            return this.posQueue.top().pe.getPayload();
        }
    }

    static class PostingsAndPosition {
        final PostingsEnum pe;
        int pos;
        int upto;

        PostingsAndPosition(PostingsEnum pe) {
            this.pe = pe;
        }
    }

    public static class UnionPostingsEnum
    extends PostingsEnum {
        final DocsQueue docsQueue;
        final long cost;
        final PositionsQueue posQueue = new PositionsQueue();
        int posQueueDoc = -2;
        final PostingsEnum[] subs;

        public UnionPostingsEnum(Collection<PostingsEnum> subs) {
            this.docsQueue = new DocsQueue(subs.size());
            long cost = 0L;
            for (PostingsEnum sub : subs) {
                this.docsQueue.add(sub);
                cost += sub.cost();
            }
            this.cost = cost;
            this.subs = subs.toArray(new PostingsEnum[subs.size()]);
        }

        @Override
        public int freq() throws IOException {
            int doc = this.docID();
            if (doc != this.posQueueDoc) {
                this.posQueue.clear();
                for (PostingsEnum sub : this.subs) {
                    if (sub.docID() != doc) continue;
                    int freq = sub.freq();
                    for (int i = 0; i < freq; ++i) {
                        this.posQueue.add(sub.nextPosition());
                    }
                }
                this.posQueue.sort();
                this.posQueueDoc = doc;
            }
            return this.posQueue.size();
        }

        @Override
        public int nextPosition() throws IOException {
            return this.posQueue.next();
        }

        @Override
        public int docID() {
            return ((PostingsEnum)this.docsQueue.top()).docID();
        }

        @Override
        public int nextDoc() throws IOException {
            PostingsEnum top = (PostingsEnum)this.docsQueue.top();
            int doc = top.docID();
            do {
                top.nextDoc();
            } while ((top = (PostingsEnum)this.docsQueue.updateTop()).docID() == doc);
            return top.docID();
        }

        @Override
        public int advance(int target) throws IOException {
            PostingsEnum top = (PostingsEnum)this.docsQueue.top();
            do {
                top.advance(target);
            } while ((top = (PostingsEnum)this.docsQueue.updateTop()).docID() < target);
            return top.docID();
        }

        @Override
        public long cost() {
            return this.cost;
        }

        @Override
        public int startOffset() throws IOException {
            return -1;
        }

        @Override
        public int endOffset() throws IOException {
            return -1;
        }

        @Override
        public BytesRef getPayload() throws IOException {
            return null;
        }

        static class PositionsQueue {
            private int arraySize = 16;
            private int index = 0;
            private int size = 0;
            private int[] array = new int[this.arraySize];

            PositionsQueue() {
            }

            void add(int i) {
                if (this.size == this.arraySize) {
                    this.growArray();
                }
                this.array[this.size++] = i;
            }

            int next() {
                return this.array[this.index++];
            }

            void sort() {
                Arrays.sort(this.array, this.index, this.size);
            }

            void clear() {
                this.index = 0;
                this.size = 0;
            }

            int size() {
                return this.size;
            }

            private void growArray() {
                int[] newArray = new int[this.arraySize * 2];
                System.arraycopy(this.array, 0, newArray, 0, this.arraySize);
                this.array = newArray;
                this.arraySize *= 2;
            }
        }

        static class DocsQueue
        extends PriorityQueue<PostingsEnum> {
            DocsQueue(int size) {
                super(size);
            }

            @Override
            public final boolean lessThan(PostingsEnum a, PostingsEnum b) {
                return a.docID() < b.docID();
            }
        }
    }

    public static class Builder {
        private String field;
        private final ArrayList<Term[]> termArrays;
        private final IntArrayList positions;
        private int slop;

        public Builder() {
            this.field = null;
            this.termArrays = new ArrayList();
            this.positions = new IntArrayList();
            this.slop = 0;
        }

        public Builder(MultiPhraseQuery multiPhraseQuery) {
            this.field = multiPhraseQuery.field;
            int length = multiPhraseQuery.termArrays.length;
            this.termArrays = new ArrayList(length);
            this.positions = new IntArrayList(length);
            for (int i = 0; i < length; ++i) {
                this.termArrays.add(multiPhraseQuery.termArrays[i]);
                this.positions.add(multiPhraseQuery.positions[i]);
            }
            this.slop = multiPhraseQuery.slop;
        }

        public Builder setSlop(int s2) {
            if (s2 < 0) {
                throw new IllegalArgumentException("slop value cannot be negative");
            }
            this.slop = s2;
            return this;
        }

        public Builder add(Term term) {
            return this.add(new Term[]{term});
        }

        public Builder add(Term[] terms) {
            int position = 0;
            if (this.positions.size() > 0) {
                position = this.positions.get(this.positions.size() - 1) + 1;
            }
            return this.add(terms, position);
        }

        public Builder add(Term[] terms, int position) {
            Objects.requireNonNull(terms, "Term array must not be null");
            if (this.termArrays.size() == 0) {
                this.field = terms[0].field();
            }
            for (Term term : terms) {
                if (term.field().equals(this.field)) continue;
                throw new IllegalArgumentException("All phrase terms must be in the same field (" + this.field + "): " + term);
            }
            this.termArrays.add(terms);
            this.positions.add(position);
            return this;
        }

        public MultiPhraseQuery build() {
            Term[][] termArraysArray = (Term[][])this.termArrays.toArray((T[])new Term[this.termArrays.size()][]);
            return new MultiPhraseQuery(this.field, termArraysArray, this.positions.toArray(), this.slop);
        }
    }
}

