/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.util.packed;

import com.dataiku.dss.shadelib.org.apache.lucene.store.IndexInput;
import com.dataiku.dss.shadelib.org.apache.lucene.store.RandomAccessInput;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Accountable;
import com.dataiku.dss.shadelib.org.apache.lucene.util.LongValues;
import com.dataiku.dss.shadelib.org.apache.lucene.util.RamUsageEstimator;
import com.dataiku.dss.shadelib.org.apache.lucene.util.packed.DirectReader;
import java.io.IOException;

public final class DirectMonotonicReader
extends LongValues
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DirectMonotonicReader.class);
    private final int blockShift;
    private final long blockMask;
    private final LongValues[] readers;
    private final long[] mins;
    private final float[] avgs;
    private final byte[] bpvs;
    private final int nonZeroBpvs;

    public static Meta loadMeta(IndexInput metaIn, long numValues, int blockShift) throws IOException {
        boolean allValuesZero = true;
        Meta meta = new Meta(numValues, blockShift);
        for (int i = 0; i < meta.numBlocks; ++i) {
            byte bpvs;
            long min2;
            meta.mins[i] = min2 = metaIn.readLong();
            int avgInt = metaIn.readInt();
            meta.avgs[i] = Float.intBitsToFloat(avgInt);
            meta.offsets[i] = metaIn.readLong();
            meta.bpvs[i] = bpvs = metaIn.readByte();
            allValuesZero = allValuesZero && min2 == 0L && avgInt == 0 && bpvs == 0;
        }
        return allValuesZero ? Meta.SINGLE_ZERO_BLOCK : meta;
    }

    public static DirectMonotonicReader getInstance(Meta meta, RandomAccessInput data) throws IOException {
        return DirectMonotonicReader.getInstance(meta, data, false);
    }

    public static DirectMonotonicReader getInstance(Meta meta, RandomAccessInput data, boolean merging) throws IOException {
        LongValues[] readers = new LongValues[meta.numBlocks];
        for (int i = 0; i < meta.numBlocks; ++i) {
            readers[i] = meta.bpvs[i] == 0 ? LongValues.ZEROES : (merging && i < meta.numBlocks - 1 && meta.blockShift >= 7 ? DirectReader.getMergeInstance(data, meta.bpvs[i], meta.offsets[i], 1L << meta.blockShift) : DirectReader.getInstance(data, meta.bpvs[i], meta.offsets[i]));
        }
        return new DirectMonotonicReader(meta.blockShift, readers, meta.mins, meta.avgs, meta.bpvs);
    }

    private DirectMonotonicReader(int blockShift, LongValues[] readers, long[] mins, float[] avgs, byte[] bpvs) {
        this.blockShift = blockShift;
        this.blockMask = (1L << blockShift) - 1L;
        this.readers = readers;
        this.mins = mins;
        this.avgs = avgs;
        this.bpvs = bpvs;
        if (readers.length != mins.length || readers.length != avgs.length || readers.length != bpvs.length) {
            throw new IllegalArgumentException();
        }
        int nonZeroBpvs = 0;
        for (byte b : bpvs) {
            if (b == 0) continue;
            ++nonZeroBpvs;
        }
        this.nonZeroBpvs = nonZeroBpvs;
    }

    @Override
    public long get(long index) {
        int block = (int)(index >>> this.blockShift);
        long blockIndex = index & this.blockMask;
        long delta = this.readers[block].get(blockIndex);
        return this.mins[block] + (long)(this.avgs[block] * (float)blockIndex) + delta;
    }

    private long[] getBounds(long index) {
        int block = Math.toIntExact(index >>> this.blockShift);
        long blockIndex = index & this.blockMask;
        long lowerBound = this.mins[block] + (long)(this.avgs[block] * (float)blockIndex);
        long upperBound = lowerBound + (1L << this.bpvs[block]) - 1L;
        if (this.bpvs[block] == 64 || upperBound < lowerBound) {
            return new long[]{Long.MIN_VALUE, Long.MAX_VALUE};
        }
        return new long[]{lowerBound, upperBound};
    }

    public long binarySearch(long fromIndex, long toIndex, long key) {
        if (fromIndex < 0L || fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex=" + fromIndex + ",toIndex=" + toIndex);
        }
        long lo = fromIndex;
        long hi = toIndex - 1L;
        while (lo <= hi) {
            long mid = lo + hi >>> 1;
            long[] bounds = this.getBounds(mid);
            if (bounds[1] < key) {
                lo = mid + 1L;
                continue;
            }
            if (bounds[0] > key) {
                hi = mid - 1L;
                continue;
            }
            long midVal = this.get(mid);
            if (midVal < key) {
                lo = mid + 1L;
                continue;
            }
            if (midVal > key) {
                hi = mid - 1L;
                continue;
            }
            return mid;
        }
        return -1L - lo;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.shallowSizeOf(this.readers) + (long)this.nonZeroBpvs * RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER);
    }

    public static class Meta
    implements Accountable {
        private static final Meta SINGLE_ZERO_BLOCK = new Meta(1L, 63);
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Meta.class);
        private final int blockShift;
        private final int numBlocks;
        private final long[] mins;
        private final float[] avgs;
        private final byte[] bpvs;
        private final long[] offsets;

        Meta(long numValues, int blockShift) {
            this.blockShift = blockShift;
            long numBlocks = numValues >>> blockShift;
            if (numBlocks << blockShift < numValues) {
                ++numBlocks;
            }
            this.numBlocks = (int)numBlocks;
            this.mins = new long[this.numBlocks];
            this.avgs = new float[this.numBlocks];
            this.bpvs = new byte[this.numBlocks];
            this.offsets = new long[this.numBlocks];
        }

        @Override
        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.mins) + RamUsageEstimator.sizeOf(this.avgs) + RamUsageEstimator.sizeOf(this.bpvs) + RamUsageEstimator.sizeOf(this.offsets);
        }
    }
}

