/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.hash;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.dataengine.utilities.ColumnMetadata;
import com.databricks.client.dsi.dataengine.utilities.TypeMetadata;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.hash.HashPartitionProperties;
import com.databricks.client.sqlengine.executor.etree.hash.IRowBinaryPredicate;
import com.databricks.client.sqlengine.executor.etree.relation.ETHashAggregate;
import com.databricks.client.sqlengine.executor.etree.relation.join.IHasher;
import com.databricks.client.sqlengine.executor.etree.relation.join.RowFile;
import com.databricks.client.sqlengine.executor.etree.temptable.DataStore;
import com.databricks.client.sqlengine.executor.etree.temptable.IRowView;
import com.databricks.client.sqlengine.executor.etree.temptable.InMemTable;
import com.databricks.client.sqlengine.executor.etree.temptable.IndexRowView;
import com.databricks.client.sqlengine.executor.etree.temptable.TemporaryFile;
import com.databricks.client.sqlengine.executor.etree.temptable.TemporaryTableBuilder;
import com.databricks.client.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.databricks.client.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.databricks.client.sqlengine.executor.etree.value.aggregatefn.IAggregator;
import com.databricks.client.sqlengine.executor.etree.value.aggregatefn.RowViewUpdateParameters;
import com.databricks.client.sqlengine.utilities.ExternalAlgorithmUtil;
import com.databricks.client.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class HashAggrPartition {
    private IHasher m_hash;
    private ETHashAggregate.AggregateProjectionInfo m_aggregateProjection;
    private ETHashAggregate.OperandProjectionInfo m_operandProjection;
    private boolean m_hasFlushedRows = false;
    private boolean m_isFinishedRetrieving = false;
    private OperationMode m_operationMode = OperationMode.WRITE;
    private int m_lastRow = -1;
    private int m_currentRow = -1;
    private InMemTable m_memTable;
    private IColumn[] m_memTableMeta;
    private TemporaryFile m_longDataStore;
    private boolean[] m_longDataColumns;
    private DataStore m_spilledPartial;
    private RowFile m_spilledInput;
    private long m_memorySize;
    private HashMap<HashedRowView, PartialAggregationRow> m_hashMap;
    private ArrayList<PartialAggregationRow> m_partialList;
    private IRowBinaryPredicate m_predicate;
    private HashPartitionProperties m_properties;
    private boolean[] m_dataNeeded;

    HashAggrPartition(IHasher iHasher, boolean[] blArray, boolean[] blArray2, TemporaryFile temporaryFile, IColumn[] iColumnArray, InMemTable inMemTable, HashPartitionProperties hashPartitionProperties) {
        this.m_hash = iHasher;
        this.m_predicate = hashPartitionProperties.getEqualityPredicate();
        this.m_hashMap = new HashMap();
        this.m_partialList = new ArrayList();
        this.m_aggregateProjection = hashPartitionProperties.getAggregateProjection();
        this.m_operandProjection = hashPartitionProperties.getOperandProjection();
        this.m_memTable = inMemTable;
        this.m_memTableMeta = iColumnArray;
        this.m_longDataColumns = blArray;
        this.m_longDataStore = temporaryFile;
        this.m_properties = hashPartitionProperties;
        this.m_dataNeeded = blArray2;
    }

    public void addPartialAggregation(IRowView iRowView) throws ErrorException {
        List<IAggregator> list;
        if (OperationMode.WRITE != this.m_operationMode) {
            throw new IllegalStateException();
        }
        int n = this.appendScalarValues(iRowView);
        int n2 = this.m_memTableMeta.length;
        int n3 = this.m_aggregateProjection.getAggregateFnColumns().length;
        if (0 < n3) {
            list = new ArrayList(n3);
            for (int i = 0; i < n3; ++i) {
                IAggregator iAggregator = this.m_aggregateProjection.createAggregator(i);
                iAggregator.load(iRowView.getBytes(n2 + i));
                list.add(iAggregator);
                this.m_memorySize += iAggregator.getMemorySize(ColumnSizeCalculator.JAVA_SIZE);
            }
        } else {
            list = Collections.emptyList();
        }
        PartialAggregationRow partialAggregationRow = new PartialAggregationRow(this.m_memTable, n, list);
        this.m_hashMap.put(new HashedRowView(this.hash(partialAggregationRow.getRow()), partialAggregationRow.getRow(), this.m_predicate), partialAggregationRow);
        this.m_partialList.add(partialAggregationRow);
    }

    public long getMemoryUsage() {
        return (long)this.m_memTable.getMemUsage() + this.m_memorySize;
    }

    public boolean hasFlushedRows() {
        return this.m_hasFlushedRows;
    }

    public boolean isFinishedRetrieving() {
        return this.m_isFinishedRetrieving;
    }

    public boolean moveToNextRow() {
        if (OperationMode.RETRIEVE != this.m_operationMode && OperationMode.WRITE != this.m_operationMode) {
            throw new IllegalStateException("" + (Object)((Object)this.m_operationMode));
        }
        this.m_operationMode = OperationMode.RETRIEVE;
        if (!this.m_isFinishedRetrieving) {
            ++this.m_currentRow;
            if (0 <= this.m_lastRow) {
                PartialAggregationRow partialAggregationRow = this.m_partialList.get(this.m_lastRow);
                this.m_memTable.removeRow(partialAggregationRow.getIndex());
            }
            this.m_lastRow = this.m_currentRow;
            if (this.m_currentRow < this.m_partialList.size()) {
                return true;
            }
            this.m_currentRow = -1;
        }
        this.m_isFinishedRetrieving = true;
        return false;
    }

    public boolean retrieveAggregate(int n, ETDataRequest eTDataRequest) throws ErrorException {
        assert (OperationMode.RETRIEVE == this.m_operationMode);
        IAggregator iAggregator = this.m_partialList.get(this.m_currentRow).getAggregators().get(n);
        return iAggregator.retrieveData(eTDataRequest);
    }

    public boolean retrieveScalar(int n, ETDataRequest eTDataRequest) throws ErrorException {
        assert (OperationMode.RETRIEVE == this.m_operationMode);
        IRowView iRowView = this.m_partialList.get(this.m_currentRow).getRow();
        return DataRetrievalUtil.retrieveFromRowView(n, this.m_longDataColumns[n], eTDataRequest, iRowView, this.m_longDataStore);
    }

    public void spillAllRows(long l) throws ErrorException {
        while (!this.m_partialList.isEmpty()) {
            this.spillPartialRows(l, 0);
        }
    }

    public void spillPartialRows(long l, int n) throws ErrorException {
        int n2;
        Object object;
        ArrayList<IColumn> arrayList = new ArrayList<IColumn>(Arrays.asList(this.m_memTableMeta));
        int n3 = this.m_aggregateProjection.getAggregateFnColumns().length;
        if (0 < n3) {
            arrayList.addAll(Collections.nCopies(n3, new ColumnMetadata(TypeMetadata.createTypeMetadata(-2))));
        }
        boolean[] blArray = new boolean[arrayList.size()];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = true;
        }
        long l2 = ExternalAlgorithmUtil.calculateRowSize(arrayList, blArray, this.m_properties.getMaxDataLen());
        l2 = Math.max(l2, 1L);
        int n4 = 1 + (int)((double)l * 0.5 / (double)l2);
        if (null == this.m_spilledPartial) {
            object = new TemporaryTableBuilder.TemporaryTableProperties(this.m_properties.getStorageDir(), this.m_properties.getMaxDataLen(), this.m_properties.getExternalAlgorithmProperties().getBlockSize(), n4, this.m_properties.getExternalAlgorithmProperties().getMaxNumOpenFiles(), this.m_properties.getLogger(), "ETHashPartition");
            this.m_spilledPartial = new DataStore((TemporaryTableBuilder.TemporaryTableProperties)object, arrayList.toArray(new IColumn[0]));
        }
        object = new InMemTable(arrayList.toArray(new IColumn[0]), this.m_properties.getMaxDataLen(), n4, blArray, null);
        ((InMemTable)object).setMemLimit(Long.MAX_VALUE);
        long l3 = Math.max(this.getMemoryUsage() - l, 0L);
        while (this.m_partialList.size() > n && this.getMemoryUsage() > l3 && 0 <= (n2 = ((InMemTable)object).appendRow())) {
            PartialAggregationRow partialAggregationRow = this.m_partialList.remove(this.m_partialList.size() - 1);
            this.m_hashMap.remove(new HashedRowView(this.hash(partialAggregationRow.getRow()), partialAggregationRow.getRow(), this.m_predicate));
            HashAggrPartition.copyRow(this.m_memTable, partialAggregationRow.getIndex(), (InMemTable)object, n2, this.m_memTableMeta, this.m_longDataColumns);
            for (int i = 0; i < n3; ++i) {
                IAggregator iAggregator = partialAggregationRow.getAggregators().get(i);
                this.m_memorySize -= iAggregator.getMemorySize(ColumnSizeCalculator.JAVA_SIZE);
                ((InMemTable)object).setBytes(n2, this.m_memTableMeta.length + i, iAggregator.serialize());
            }
            this.m_memTable.removeRow(partialAggregationRow.getIndex());
        }
        this.m_spilledPartial.put(((InMemTable)object).toRowBlock());
        this.m_hasFlushedRows = true;
    }

    public DataStore unspillPartial() {
        this.m_operationMode = OperationMode.UNSPILL;
        DataStore dataStore = this.m_spilledPartial;
        this.m_spilledPartial = null;
        return dataStore;
    }

    public RowFile unspillInputRows() {
        this.m_operationMode = OperationMode.UNSPILL;
        RowFile rowFile = this.m_spilledInput;
        this.m_spilledInput = null;
        return rowFile;
    }

    public void update(IRowView iRowView) throws ErrorException {
        if (OperationMode.WRITE != this.m_operationMode) {
            throw new IllegalStateException("" + (Object)((Object)this.m_operationMode));
        }
        HashedRowView hashedRowView = new HashedRowView(this.hash(iRowView), iRowView, this.m_predicate);
        if (!this.findAndUpdate(hashedRowView)) {
            if (!this.hasFlushedRows()) {
                PartialAggregationRow partialAggregationRow = this.createPartialAggregation(iRowView);
                this.m_hashMap.put(new HashedRowView(hashedRowView.hashCode(), partialAggregationRow.getRow(), this.m_predicate), partialAggregationRow);
                this.m_partialList.add(partialAggregationRow);
            } else {
                this.spillInputRow(iRowView);
            }
        }
    }

    private int appendScalarValues(IRowView iRowView) {
        int n = this.m_memTable.appendRow();
        assert (0 <= n);
        int[] nArray = this.m_operandProjection.getScalarValueColumns();
        block5: for (int i = 0; i < this.m_memTableMeta.length; ++i) {
            TypeMetadata typeMetadata = this.m_memTableMeta[i].getTypeMetadata();
            int n2 = nArray[i];
            if (iRowView.isNull(n2)) {
                this.m_memTable.setNull(n, i);
                continue;
            }
            switch (typeMetadata.getType()) {
                case -7: 
                case 16: {
                    this.m_memTable.setBoolean(n, i, iRowView.getBoolean(n2));
                    continue block5;
                }
                case 4: {
                    this.m_memTable.setInteger(n, i, iRowView.getInteger(n2));
                    continue block5;
                }
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    if (this.m_longDataColumns[n2]) {
                        this.m_memTable.setFileMarker(n, i, iRowView.getFileMarker(n2));
                        continue block5;
                    }
                    this.m_memTable.setString(n, i, iRowView.getString(n2));
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException(typeMetadata.getTypeName());
                }
            }
        }
        return n;
    }

    private PartialAggregationRow createPartialAggregation(IRowView iRowView) throws ErrorException {
        List<IAggregator> list;
        int n = this.m_aggregateProjection.getAggregateFnColumns().length;
        if (0 < n) {
            list = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                IAggregator iAggregator = this.m_aggregateProjection.createAggregator(i);
                iAggregator.update(this.createUpdateParams(i, iRowView));
                list.add(iAggregator);
                this.m_memorySize += iAggregator.getMemorySize(ColumnSizeCalculator.JAVA_SIZE);
            }
        } else {
            list = Collections.emptyList();
        }
        return new PartialAggregationRow(this.m_memTable, this.appendScalarValues(iRowView), list);
    }

    private RowViewUpdateParameters createUpdateParams(int n, IRowView iRowView) {
        IColumn[] iColumnArray = this.m_aggregateProjection.getAggregateFnArgumentMetadata(n);
        int[] nArray = this.m_aggregateProjection.getAggregateFnArguments(n);
        boolean[] blArray = new boolean[nArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.m_longDataColumns[nArray[i]];
        }
        return new RowViewUpdateParameters(new RenumberedRowView(iRowView, nArray), iColumnArray, blArray);
    }

    private boolean findAndUpdate(HashedRowView hashedRowView) throws ErrorException {
        PartialAggregationRow partialAggregationRow = this.m_hashMap.get(hashedRowView);
        if (null != partialAggregationRow) {
            List<IAggregator> list = partialAggregationRow.getAggregators();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                list.get(i).update(this.createUpdateParams(i, hashedRowView.getRowView()));
            }
            return true;
        }
        return false;
    }

    private long hash(IRowView iRowView) {
        return this.m_hash.hash(iRowView, this.m_operandProjection.getGroupingColumns());
    }

    private void spillInputRow(IRowView iRowView) throws ErrorException {
        if (null == this.m_spilledInput) {
            this.m_spilledInput = new RowFile(this.m_operandProjection.getMetadata(), this.m_properties.getStorageDir(), this.m_properties.getLogger(), this.m_properties.getMaxDataLen(), this.m_dataNeeded);
        }
    }

    private static void copyRow(InMemTable inMemTable, int n, InMemTable inMemTable2, int n2, IColumn[] iColumnArray, boolean[] blArray) throws ErrorException {
        block4: for (int i = 0; i < iColumnArray.length; ++i) {
            if (inMemTable.isNull(n, i)) {
                inMemTable2.setNull(n2, i);
                continue;
            }
            switch (iColumnArray[i].getTypeMetadata().getType()) {
                case 4: {
                    continue block4;
                }
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    if (blArray[i]) {
                        inMemTable2.setFileMarker(n2, i, inMemTable.getFileMarker(n, i));
                        continue block4;
                    }
                    inMemTable2.setString(n2, i, inMemTable.getString(n, i));
                    continue block4;
                }
                default: {
                    throw SQLEngineExceptionFactory.featureNotImplementedException(iColumnArray[i].getTypeMetadata().getTypeName());
                }
            }
        }
    }

    private static final class RenumberedRowView
    implements IRowView {
        private final IRowView m_rowView;
        private final int[] m_indices;

        public RenumberedRowView(IRowView iRowView, int[] nArray) {
            this.m_rowView = iRowView;
            this.m_indices = nArray;
        }

        @Override
        public boolean isNull(int n) {
            return this.m_rowView.isNull(this.m_indices[n]);
        }

        @Override
        public long getBigInt(int n) {
            return this.m_rowView.getBigInt(this.m_indices[n]);
        }

        @Override
        public BigDecimal getExactNumber(int n) {
            return this.m_rowView.getExactNumber(this.m_indices[n]);
        }

        @Override
        public double getDouble(int n) {
            return this.m_rowView.getDouble(this.m_indices[n]);
        }

        @Override
        public TemporaryFile.FileMarker getFileMarker(int n) {
            return this.m_rowView.getFileMarker(this.m_indices[n]);
        }

        @Override
        public float getReal(int n) {
            return this.m_rowView.getReal(this.m_indices[n]);
        }

        @Override
        public boolean getBoolean(int n) {
            return this.m_rowView.getBoolean(this.m_indices[n]);
        }

        @Override
        public String getString(int n) {
            return this.m_rowView.getString(this.m_indices[n]);
        }

        @Override
        public Date getDate(int n) {
            return this.m_rowView.getDate(this.m_indices[n]);
        }

        @Override
        public Time getTime(int n) {
            return this.m_rowView.getTime(this.m_indices[n]);
        }

        @Override
        public Timestamp getTimestamp(int n) {
            return this.m_rowView.getTimestamp(this.m_indices[n]);
        }

        @Override
        public UUID getGuid(int n) {
            return this.m_rowView.getGuid(this.m_indices[n]);
        }

        @Override
        public int getInteger(int n) {
            return this.m_rowView.getInteger(this.m_indices[n]);
        }

        @Override
        public short getSmallInt(int n) {
            return this.m_rowView.getSmallInt(this.m_indices[n]);
        }

        @Override
        public byte getTinyInt(int n) {
            return this.m_rowView.getTinyInt(this.m_indices[n]);
        }

        @Override
        public byte[] getBytes(int n) {
            return this.m_rowView.getBytes(this.m_indices[n]);
        }

        @Override
        public IColumn getColumn(int n) {
            return this.m_rowView.getColumn(this.m_indices[n]);
        }
    }

    private static final class PartialAggregationRow {
        private int m_rowIndex;
        private IndexRowView m_rowView;
        private List<IAggregator> m_aggregators;

        public PartialAggregationRow(InMemTable inMemTable, int n, List<IAggregator> list) {
            this.m_rowIndex = n;
            this.m_rowView = new IndexRowView(inMemTable);
            this.m_rowView.setRowNum(n);
            this.m_aggregators = list;
        }

        public int getIndex() {
            return this.m_rowIndex;
        }

        public IRowView getRow() {
            return this.m_rowView;
        }

        public List<IAggregator> getAggregators() {
            return this.m_aggregators;
        }
    }

    private static final class HashedRowView {
        private final long m_hashCode;
        private IRowView m_rowView;
        private final IRowBinaryPredicate m_predicate;

        public HashedRowView(long l, IRowView iRowView, IRowBinaryPredicate iRowBinaryPredicate) {
            this.m_hashCode = l;
            this.m_rowView = iRowView;
            this.m_predicate = iRowBinaryPredicate;
        }

        public IRowView getRowView() {
            return this.m_rowView;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof HashedRowView)) {
                return false;
            }
            HashedRowView hashedRowView = (HashedRowView)object;
            return this.m_hashCode == hashedRowView.m_hashCode && this.m_predicate.apply(this.m_rowView, hashedRowView.m_rowView);
        }

        public int hashCode() {
            return (int)(this.m_hashCode ^ this.m_hashCode >>> 32);
        }
    }

    private static enum OperationMode {
        WRITE,
        RETRIEVE,
        UNSPILL;

    }
}

