/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.nio.file.Paths;
import java.security.InvalidKeyException;
import net.snowflake.spark.snowflake.ServerConnection$;
import net.snowflake.spark.snowflake.SnowflakeConnectorException;
import net.snowflake.spark.snowflake.pushdowns.SnowflakeStrategy;
import org.apache.spark.sql.ExperimentalMethods;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.SparkStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxesRunTime;

public final class SnowflakeConnectorUtils$ {
    public static SnowflakeConnectorUtils$ MODULE$;
    private transient Logger log;
    private final String SUPPORT_SPARK_VERSION;
    private volatile transient boolean bitmap$trans$0;

    static {
        new SnowflakeConnectorUtils$();
    }

    private Logger log$lzycompute() {
        SnowflakeConnectorUtils$ snowflakeConnectorUtils$ = this;
        synchronized (snowflakeConnectorUtils$) {
            if (!this.bitmap$trans$0) {
                this.log = LoggerFactory.getLogger((String)this.getClass().getName());
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public String SUPPORT_SPARK_VERSION() {
        return this.SUPPORT_SPARK_VERSION;
    }

    public boolean checkVersionAndEnablePushdown(SparkSession session) {
        boolean bl;
        if (session.version().startsWith(this.SUPPORT_SPARK_VERSION())) {
            this.enablePushdownSession(session);
            bl = true;
        } else {
            this.log().warn(new StringBuilder(239).append("Query pushdown is not supported because you are using ").append("Spark ").append(session.version()).append(" with a connector designed to support Spark ").append(this.SUPPORT_SPARK_VERSION()).append(". Either use the version of Spark supported by ").append("the connector or install a version of the connector that supports ").append("your version of Spark.").toString());
            this.disablePushdownSession(session);
            bl = false;
        }
        return bl;
    }

    public void enablePushdownSession(SparkSession session) {
        block0: {
            if (session.experimental().extraStrategies().exists((Function1 & java.io.Serializable & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)SnowflakeConnectorUtils$.$anonfun$enablePushdownSession$1(s)))) break block0;
            ExperimentalMethods experimentalMethods = session.experimental();
            experimentalMethods.extraStrategies_$eq((Seq)experimentalMethods.extraStrategies().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SnowflakeStrategy[]{new SnowflakeStrategy()})), Seq$.MODULE$.canBuildFrom()));
        }
    }

    public void disablePushdownSession(SparkSession session) {
        session.experimental().extraStrategies_$eq((Seq)session.experimental().extraStrategies().filterNot((Function1 & java.io.Serializable & Serializable)strategy -> BoxesRunTime.boxToBoolean((boolean)SnowflakeConnectorUtils$.$anonfun$disablePushdownSession$1(strategy))));
    }

    public void setPushdownSession(SparkSession session, boolean enabled) {
        if (enabled) {
            this.enablePushdownSession(session);
        } else {
            this.disablePushdownSession(session);
        }
    }

    public void handleS3Exception(Exception ex) throws SnowflakeConnectorException {
        if (ex.getCause() instanceof InvalidKeyException) {
            String msg = "Strong encryption with Java JRE requires JCE Unlimited Strength Jurisdiction Policy files. Follow JDBC client installation instructions provided by Snowflake or contact Snowflake Support. This needs to be installed in the Java runtime for all Spark executor nodes.";
            this.log().error("JCE Unlimited Strength policy files missing: {}. {}.", (Object)ex.getMessage(), (Object)ex.getCause().getMessage());
            String bootLib = System.getProperty("sun.boot.library.path");
            if (bootLib != null) {
                msg = new StringBuilder(41).append(msg).append(" The target directory on your system is: ").append(((Object)Paths.get(bootLib, "security")).toString()).toString();
                this.log().error(msg);
            }
            throw new SnowflakeConnectorException(msg);
        }
        throw ex;
    }

    public void enableSharingJDBCConnection() {
        ServerConnection$.MODULE$.setSupportSharingJDBCConnection(true);
    }

    public void disableSharingJDBCConnection() {
        ServerConnection$.MODULE$.setSupportSharingJDBCConnection(false);
    }

    public static final /* synthetic */ boolean $anonfun$enablePushdownSession$1(SparkStrategy s) {
        return s instanceof SnowflakeStrategy;
    }

    public static final /* synthetic */ boolean $anonfun$disablePushdownSession$1(SparkStrategy strategy) {
        return strategy instanceof SnowflakeStrategy;
    }

    private SnowflakeConnectorUtils$() {
        MODULE$ = this;
        this.SUPPORT_SPARK_VERSION = "3.2";
    }
}

