/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import javax.measure.IncommensurableException;
import javax.measure.MetricPrefix;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Length;
import javax.measure.quantity.Time;
import org.geotools.measure.SexagesimalConverter;
import org.geotools.measure.UnitFormat;
import org.geotools.measure.UnitFormatter;
import org.geotools.measure.WktUnitFormat;
import si.uom.NonSI;
import si.uom.SI;
import systems.uom.common.USCustomary;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.unit.TransformedUnit;

public final class Units {
    public static final Unit<Angle> DEGREE_ANGLE = NonSI.DEGREE_ANGLE;
    public static final Unit<Angle> DEGREE_MINUTE_SECOND = NonSI.DEGREE_ANGLE.transform((UnitConverter)SexagesimalConverter.INTEGER.inverse()).asType(Angle.class);
    public static final Unit<Angle> GRADE = USCustomary.GRADE;
    public static final Unit<Angle> MICRORADIAN = MetricPrefix.MICRO((Unit)tech.units.indriya.unit.Units.RADIAN);
    public static final Unit<Angle> MINUTE_ANGLE = NonSI.MINUTE_ANGLE;
    public static final Unit<Angle> RADIAN = tech.units.indriya.unit.Units.RADIAN;
    public static final Unit<Angle> SEXAGESIMAL_DMS = NonSI.DEGREE_ANGLE.transform((UnitConverter)SexagesimalConverter.FRACTIONAL.inverse()).asType(Angle.class);
    public static final Unit<Angle> SECOND_ANGLE = NonSI.SECOND_ANGLE;
    public static final Unit<Dimensionless> PPM = AbstractUnit.ONE.multiply(1.0E-6);
    public static final Unit<Dimensionless> ONE = AbstractUnit.ONE;
    public static final Unit<Length> FOOT = USCustomary.FOOT;
    public static final Unit<Length> METRE = tech.units.indriya.unit.Units.METRE;
    public static final Unit<Length> KILOMETER = MetricPrefix.KILO(METRE);
    public static final Unit<Length> NAUTICAL_MILE = USCustomary.NAUTICAL_MILE;
    static final Unit<Length> FOOT_GOLD_COAST = new TransformedUnit("Foot_Gold_Coast", SI.METRE, (UnitConverter)MultiplyConverter.of((double)0.3047997101815088));
    public static final Unit<Length> PIXEL = USCustomary.INCH.divide(72.0);
    public static final Unit<Time> DAY = SI.DAY;
    public static final Unit<Time> MONTH = SI.YEAR.divide(12.0);
    public static final Unit<Time> YEAR = SI.YEAR;

    private Units() {
    }

    public static UnitFormatter getDefaultFormat() {
        return UnitFormat.getInstance();
    }

    public static String toName(Unit<?> unit) {
        if (unit.getName() != null) {
            return unit.getName();
        }
        UnitFormatter format = UnitFormat.getInstance();
        return format.format(unit);
    }

    public static String toSymbol(Unit<?> unit) {
        UnitFormatter format = UnitFormat.getInstance();
        return format.format(unit);
    }

    public static <Q extends Quantity<Q>> Unit<Q> autoCorrect(Unit<Q> unit) {
        return ((WktUnitFormat.WktUnitFormatterImpl)WktUnitFormat.getInstance()).getEquivalentUnit(unit);
    }

    public static final boolean equals(Unit<?> unit1, Unit<?> unit2) {
        if (unit1 == unit2) {
            return true;
        }
        if (unit1 != null) {
            if (unit1 instanceof TransformedUnit && unit2 != null && unit2 instanceof TransformedUnit) {
                TransformedUnit tunit1 = (TransformedUnit)unit1;
                TransformedUnit tunit2 = (TransformedUnit)unit2;
                if (unit1.getSystemUnit().equals(unit2.getSystemUnit())) {
                    try {
                        float factor = (float)tunit1.getSystemConverter().concatenate(tunit2.getSystemConverter().inverse()).convert(1.0);
                        return factor == 1.0f;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return unit1.equals(unit2);
        }
        return false;
    }

    public static UnitConverter getConverterToAny(Unit<?> fromUnit, Unit<?> toUnit) {
        try {
            return fromUnit.getConverterToAny(toUnit);
        }
        catch (IncommensurableException | UnconvertibleException e) {
            throw new IllegalArgumentException("Can't convert to the candidate unit", e);
        }
    }

    public static Unit<?> parseUnit(String name) {
        return Units.autoCorrect(WktUnitFormat.getInstance().parse(name));
    }
}

