"""The Jupyter HTML Notebook"""

import os
# Packagers: modify this line if you store the notebook static files elsewhere
DEFAULT_STATIC_FILES_PATH = os.path.join(os.path.dirname(__file__), "static")

# Packagers: modify the next line if you store the notebook template files
# elsewhere

# Include both notebook/ and notebook/templates/.  This makes it
# possible for users to override a template with a file that inherits from that
# template.
#
# For example, if you want to override a specific block of notebook.html, you
# can create a file called notebook.html that inherits from
# templates/notebook.html, and the latter will resolve correctly to the base
# implementation.
DEFAULT_TEMPLATE_PATH_LIST = [
    os.path.dirname(__file__),
    os.path.join(os.path.dirname(__file__), "templates"),
]

DEFAULT_NOTEBOOK_PORT = 8888

del os

from .nbextensions import install_nbextension
from ._version import version_info, __version__

# See sc-276266
# TLDR: we need to enable shared_context for jupyter-client. This creates an exception in tornado ("fd .. added twice"). This patch
# calls the removal of each fd that we want to add. `remove_handler()` is a no-op if the fd doesn't exist, so it's safe.
from notebook.dataiku.dipproperties import DipProperties, PATCH_TORNADO
_patch_tornado_prop = DipProperties().get(PATCH_TORNADO)
if not _patch_tornado_prop or _patch_tornado_prop == "true":
    from tornado.platform.asyncio import AsyncIOMainLoop
    class PatchAsyncIOMainLoop(AsyncIOMainLoop):
        def add_handler(self, fd, handler, events) -> None:
            self.remove_handler(fd)
            super(AsyncIOMainLoop, self).add_handler(fd, handler, events)

    AsyncIOMainLoop.add_handler = PatchAsyncIOMainLoop.add_handler
