(function(){
    'use strict';

    const app = angular.module('dataiku.dashboards');

    /**
     * Was previously located here: src/main/platypus/static/dataiku/js/dashboards/edit.js
     */
    app.controller('NewDashboardModalController', function($scope, $stateParams, $rootScope, DataikuAPI, DashboardUtils, DSSVisualizationThemeUtils, WT1) {
        $scope.dashboard = {
            projectKey: $stateParams.projectKey,
            owner: $scope.appConfig.user.login,
            pages: [{ grid: { tiles: [] } }]
        };

        $scope.defaultDashboardName = DashboardUtils.getDashboardDefaultName();

        $scope.create = function() {
            $scope.dashboard.name = $scope.dashboard.name || $scope.defaultDashboardName;
            $scope.dashboard.autoStackUp = $rootScope.appConfig.userSettings.dashboards.autoStackUp;
            $scope.dashboard.theme = DSSVisualizationThemeUtils.getThemeOrDefault($rootScope.appConfig.selectedDSSVisualizationTheme);
            DSSVisualizationThemeUtils.applyToDashboard($scope.dashboard, $scope.dashboard.theme);

            DataikuAPI.dashboards.save($scope.dashboard).success(function(dashboard) {
                $scope.dashboard = dashboard;
                $scope.resolveModal($scope.dashboard);
                WT1.tryEvent('dashboard-create', () => ({ source: 'dashboards-list' }));
            }).error(setErrorInScope.bind($scope));
        };
    });
})();
