(function() {
    'use strict';
    const app = angular.module('dataiku.recipes');

    app.controller("ExtractContentRecipeCreationController", function($scope, Fn, $stateParams, DataikuAPI, $q,Dialogs, WT1, $controller, RecipeComputablesService, Logger, SmartId, RetrievableKnowledgeUtils, $rootScope) {

        $scope.recipeType = "extract_content";
        $scope.inputFolderOnly = true;

        $controller("SingleOutputDatasetRecipeCreationController", {$scope: $scope});

        $scope.autosetName = async function() {
            if ($scope.io.inputFolder && $scope.io.inputFolder.name) {
                const niceInputName = (await DataikuAPI.shakers.convertToASCII([$scope.io.inputFolder.name], true, true)).data[0];
                $scope.maybeSetNewDatasetName(niceInputName + "_extracted_content");
            }
        };

        $scope.recipeName = {};
        $scope.creationSettings = {
            VLMId : null,
            zone: null,
            outputRetrievableKnowledgeName: null
        
        };
        $scope.recipe = {
            type: $scope.recipeType,
            projectKey: $stateParams.projectKey,
            inputs: {
                main: {
                    items: []
                }
            },
            outputs: {
                main: {
                    items: []
                }
            },
            
            name: "compute_" + $scope.creationSettings.outputRetrievableKnowledgeName,
        };

        $scope.$watchCollection('recipe.inputs.main.items', function (inputs) {
            // when creating the recipe without a preselected folder (+recipe from flow) $scope.io.inputFolder is not set. 
            if (inputs && inputs.length && $scope.computablesMap) {
                const folderId = inputs[0].ref;
                $scope.io.inputFolder = {smartName: folderId, name: $scope.computablesMap[folderId] && $scope.computablesMap[folderId].label};

                DataikuAPI.flow.zones.getZoneId($stateParams.projectKey, {id: folderId, type: "MANAGED_FOLDER", projectKey: $stateParams.projectKey}).success(function(zone) {
                    $scope.zone = zone.id;
                }).error(setErrorInScope.bind($scope));
            }
        })

        RecipeComputablesService.getComputablesMap($scope.recipe, $scope).then(function(map) {
            $scope.setComputablesMap(map);
        });
    });

    app.controller("ExtractContentRecipeController", function($scope, $state, $rootScope, $q, $controller, $stateParams, DataikuAPI, RequestCenterService, EmbeddingUtils, 
    DOCUMENT_SPLITTING_METHOD_MAP, EXTRACT_CONTENT_UPDATE_METHOD_MAP, VECTOR_STORE_TYPE_MAP, DatasetUtils, RecipesUtils, SmartId) {

        $controller("_DocExtractionRecipeControllerBase", {$scope: $scope, UPDATE_METHOD_MAP: EXTRACT_CONTENT_UPDATE_METHOD_MAP});

        $scope.hasMetadataStep = false;
        $scope.ruleSchema = $scope.baseRuleSchema; // rules schema isn't dynamic for the extract content recipe since not metadata column is selectable.

        $scope.makeDefaultSplittingSettings = function() {
            return null; // no splitting
        }


        $scope.updateMethodDisabledReason = function(method) {
            return method!= "OVERWRITE"? "Unsupported update method": ""; // update methods not yet implemented for extract content recipe.
        };

        $scope.isImageStorageEnabled = function() {
            return $scope.recipe.params.extractionMode === 'MANAGED_TEXT_ONLY' ||
                ($scope.recipe.params.extractionMode === 'CUSTOM_RULES' &&
                ($scope.recipe.params.allOtherRule.actionToPerform === 'STRUCTURED' || $scope.recipe.params.rules.some(r => r.actionToPerform === 'STRUCTURED')))
        }

        $scope.imageStorageTooltip = function() {
          return !$scope.isImageStorageEnabled() ? "Requires a Structured text engine to generate images. Select a Structured text engine in one of the rules from the Strategy step to enable this option." : '';
        };

        $scope.isScreenshotStorageEnabled = function() {
            return $scope.recipe.params.extractionMode === 'MANAGED_VISUAL_ONLY' ||
                ($scope.recipe.params.extractionMode === 'CUSTOM_RULES' &&
                ($scope.recipe.params.allOtherRule.actionToPerform === 'VLM' || $scope.recipe.params.rules.some(r => r.actionToPerform === 'VLM')))
        }

        $scope.screenshotStorageTooltip = function() {
          return !$scope.isScreenshotStorageEnabled() ? "Requires a VLM engine to generate images. Select a VLM engine in one of the rules from the Strategy step to enable this option." : '';
        };


    });

})();
