(function() {
    'use strict';

    const DATE_PART_LABELS = {
        YEAR: 'Year',
        QUARTER_OF_YEAR: 'Quarter',
        MONTH_OF_YEAR: 'Month',
        WEEK_OF_YEAR: 'Week',
        DAY_OF_MONTH: 'Day',
        HOUR_OF_DAY: 'Hour'
    };

    const customRelativeDateFacetComponent = {
        templateUrl: '/static/dataiku/shared/components/custom-relative-date-facet/custom-relative-date-facet.component.html',
        bindings: {
            relativeOption: '<',
            datePart: '<',
            onChange: '&'
        },
        controller: function(translate, ChartFilterUtils) {
            const $ctrl = this;
            $ctrl.hasNext = false;
            $ctrl.hasLast = false;
            $ctrl.currentNext = 1;
            $ctrl.currentLast = 1;

            $ctrl.$onChanges = (changes) => {
                if (changes.relativeOption || changes.datePart) {
                    updateFacetWithRelativeOption($ctrl.relativeOption);
                    updateDatePartLabels();
                }
            };

            $ctrl.onContainsCurrentDatePartChange = () => {
                if (!$ctrl.relativeOption.containsCurrentDatePart) {
                    $ctrl.relativeOption.isUntilNow = false;
                }
                emitOnChange();
            }

            $ctrl.onIsUntilNowChange = () => {
                if ($ctrl.relativeOption.isUntilNow) {
                    $ctrl.relativeOption.next = 0;
                    $ctrl.hasNext = false;
                }
                emitOnChange();
            }

            $ctrl.onHasLastChange = () => {
                if ($ctrl.hasLast) {
                    $ctrl.relativeOption.last = $ctrl.currentLast;
                    if ($ctrl.hasNext) {
                        $ctrl.relativeOption.containsCurrentDatePart = true;
                    }
                } else {
                    $ctrl.relativeOption.last = 0;
                }
                emitOnChange();
            }

            $ctrl.onHasNextChange = () => {
                if ($ctrl.hasNext) {
                    $ctrl.relativeOption.next = $ctrl.currentNext;
                    if ($ctrl.hasLast) {
                        $ctrl.relativeOption.containsCurrentDatePart = true;
                    }
                } else {
                    $ctrl.relativeOption.next = 0;
                }
                emitOnChange();
            }

            $ctrl.onLastChange = () => {
                if ($ctrl.currentLast != null) {
                    $ctrl.relativeOption.last = $ctrl.currentLast;
                    emitOnChange();
                }
            }

            $ctrl.onNextChange = () => {
                if ($ctrl.currentNext != null) {
                    $ctrl.relativeOption.next = $ctrl.currentNext;
                    emitOnChange();
                }
            }

            $ctrl.focusInputNumberOnArrowClick = (event) => {
                /*
                * Firefox doesn't focus <input type="number> on arrow click,
                * so "blur" won't fire. Force focus for consistency.
                */
                event.currentTarget.focus();
            }

            function emitOnChange() {
                updateFacetWithRelativeOption($ctrl.relativeOption);
                updateDatePartLabels();
                $ctrl.onChange({ $relativeOption: $ctrl.relativeOption });
            }

            function updateFacetWithRelativeOption(relativeOption) {
                if (relativeOption == null) {
                    $ctrl.relativeOption = ChartFilterUtils.getEmptyRelativeDateFilterOption();
                    $ctrl.onChange({ $relativeOption: $ctrl.relativeOption });
                } else {
                    $ctrl.relativeOption = relativeOption;
                }
                
                $ctrl.hasLast = !!$ctrl.relativeOption.last;
                $ctrl.hasNext = !!$ctrl.relativeOption.next;
                
                if ($ctrl.hasLast) {
                    $ctrl.currentLast = $ctrl.relativeOption.last;
                } else {
                    $ctrl.currentLast = 1;
                }
                
                if ($ctrl.hasNext) {
                    $ctrl.currentNext = $ctrl.relativeOption.next;
                } else {
                    $ctrl.currentNext = 1;
                }
            }

            function updateDatePartLabels() {
                const partLabelEn = DATE_PART_LABELS[$ctrl.datePart];
                const last =  $ctrl.currentLast;
                const next =  $ctrl.currentNext;
                $ctrl.dateRelativeFilterPartsLabelThis = translate("SHAKER.PROCESSOR.FilterOnDate.FORM.THIS." + $ctrl.datePart,
                    "This " + partLabelEn);
                $ctrl.dateRelativeFilterPartsLabelLast = translate("SHAKER.PROCESSOR.FilterOnDate.FORM.NEXT_LAST." + $ctrl.datePart,
                    partLabelEn + (last > 1 ? 's' : ''), {count:last});
                $ctrl.dateRelativeFilterPartsLabelNext = translate("SHAKER.PROCESSOR.FilterOnDate.FORM.NEXT_LAST." + $ctrl.datePart,
                    partLabelEn + (next > 1 ? 's' : ''), {count:next});
                $ctrl.dateRelativeFilterPartsLabelToDate = translate("SHAKER.PROCESSOR.FilterOnDate.FORM.TO_DATE.UNTIL_NOW");
            }
        }
    };

    angular.module('dataiku.shared').component('customRelativeDateFacet', customRelativeDateFacetComponent);
})();
