import logging
import os

import sys

from dataiku.base.folder_context import build_folder_context
from dataiku.base.utils import ErrorMonitoringWrapper
from dataiku.doctor.deephub.deephub_params import DeepHubTrainingParams
from dataiku.doctor.deephub.launch_training import launch_training


def main(exec_folder):
    logging.basicConfig(level=logging.INFO,
                        format='[%(asctime)s] [%(process)s/%(threadName)s] [%(levelname)s] [%(name)s] %(message)s')
    exec_folder_context = build_folder_context(exec_folder)
    tmp_folder_info = exec_folder_context.read_json("_etmp_folder_info.json")
    split_folder = os.path.join(exec_folder, "split")
    split_folder_context = build_folder_context(split_folder)
    split_desc = split_folder_context.read_json("split.json")
    core_params = exec_folder_context.read_json("core_params.json")
    preprocessing_params = exec_folder_context.read_json("rpreprocessing_params.json")
    modeling_params = exec_folder_context.read_json("rmodeling_params.json")
    params = DeepHubTrainingParams(core_params, modeling_params, preprocessing_params, split_desc,
                                   exec_folder, exec_folder_context, split_folder, tmp_folder_info["folder"])

    launch_training(params)


if __name__ == "__main__":

    with ErrorMonitoringWrapper():
        main(sys.argv[1])
