CREATE TABLE blueprint_version_migration_paths (
    blueprint_version_migration_path_id TEXT PRIMARY KEY GENERATED ALWAYS AS ((blueprint_version_migration_json ->> 'id')::TEXT) STORED,
    blueprint_version_migration_blueprint_id_from TEXT GENERATED ALWAYS AS ((blueprint_version_migration_json -> 'blueprintVersionIdFrom' ->> 'blueprintId')::TEXT) STORED NOT NULL,
    blueprint_version_migration_version_id_from TEXT GENERATED ALWAYS AS ((blueprint_version_migration_json -> 'blueprintVersionIdFrom' ->> 'versionId')::TEXT) STORED NOT NULL,
    blueprint_version_migration_blueprint_id_to TEXT GENERATED ALWAYS AS ((blueprint_version_migration_json -> 'blueprintVersionIdTo' ->> 'blueprintId')::TEXT) STORED NOT NULL,
    blueprint_version_migration_version_id_to TEXT GENERATED ALWAYS AS ((blueprint_version_migration_json -> 'blueprintVersionIdTo' ->> 'versionId')::TEXT) STORED NOT NULL,
    blueprint_version_migration_json JSONB NOT NULL
);
ALTER TABLE blueprint_version_migration_paths ADD CONSTRAINT blueprint_version_migration_p_blueprint_version_migration_fkey FOREIGN KEY (blueprint_version_migration_blueprint_id_from, blueprint_version_migration_version_id_from) REFERENCES blueprint_versions(blueprint_version_blueprint_id, blueprint_version_version_id);
ALTER TABLE blueprint_version_migration_paths ADD CONSTRAINT blueprint_version_migration__blueprint_version_migration_fkey1 FOREIGN KEY (blueprint_version_migration_blueprint_id_to, blueprint_version_migration_version_id_to) REFERENCES blueprint_versions(blueprint_version_blueprint_id, blueprint_version_version_id);

CREATE TABLE blueprint_version_migration_paths_history (
    blueprint_version_migration_id TEXT GENERATED ALWAYS AS ((blueprint_version_migration_json ->> 'id')::TEXT) STORED,
    blueprint_version_migration_blueprint_id_from TEXT GENERATED ALWAYS AS ((blueprint_version_migration_json -> 'blueprintVersionIdFrom' ->> 'blueprintId')::TEXT) STORED NOT NULL,
    blueprint_version_migration_version_id_from TEXT GENERATED ALWAYS AS ((blueprint_version_migration_json -> 'blueprintVersionIdFrom' ->> 'versionId')::TEXT) STORED NOT NULL,
    blueprint_version_migration_blueprint_id_to TEXT GENERATED ALWAYS AS ((blueprint_version_migration_json -> 'blueprintVersionIdTo' ->> 'blueprintId')::TEXT) STORED NOT NULL,
    blueprint_version_migration_version_id_to TEXT GENERATED ALWAYS AS ((blueprint_version_migration_json -> 'blueprintVersionIdTo' ->> 'versionId')::TEXT) STORED NOT NULL,
    blueprint_version_migration_json JSONB NOT NULL,
    PRIMARY KEY (_revision_id)
) INHERITS (_history_revisions);
CREATE INDEX blueprint_version_migration_paths_bvmid_index ON blueprint_version_migration_paths_history (blueprint_version_migration_id);
