/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hive.metastore;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.catalog.DSSHiveCatalogPartition;
import com.dataiku.dip.hive.catalog.DSSHiveCatalogTable;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.log4j.Logger;

public class DSSHiveCatalogToHiveConverter {
    private static final Logger logger = Logger.getLogger((String)"dku.hive.catalog");

    public static Database convertDatabase(String databaseName) {
        Database hiveDatabase = new Database();
        hiveDatabase.setName(databaseName);
        hiveDatabase.setDescription("DSS database " + databaseName);
        hiveDatabase.setLocationUri("");
        hiveDatabase.setParameters(new HashMap());
        return hiveDatabase;
    }

    public static FieldSchema convertFieldSchema(SchemaColumn dssColumn) {
        FieldSchema hiveFieldSchema = new FieldSchema();
        hiveFieldSchema.setType(HiveSchemaHandler.hiveTypeFromSchemaType((SchemaColumn)dssColumn));
        hiveFieldSchema.setName(dssColumn.getName());
        hiveFieldSchema.setComment(dssColumn.comment);
        return hiveFieldSchema;
    }

    public static List<FieldSchema> convertFieldSchemaList(List<SchemaColumn> dssColumns) {
        ArrayList<FieldSchema> hiveFieldSchemaList = new ArrayList<FieldSchema>();
        if (dssColumns == null) {
            return hiveFieldSchemaList;
        }
        for (SchemaColumn dssColumn : dssColumns) {
            hiveFieldSchemaList.add(DSSHiveCatalogToHiveConverter.convertFieldSchema(dssColumn));
        }
        return hiveFieldSchemaList;
    }

    public static Table convertTable(DSSHiveCatalogTable catalogTable) {
        logger.info((Object)("Converting table to hive: " + JSON.json((Object)catalogTable)));
        Table hiveTable = new Table();
        hiveTable.setTableType("EXTERNAL_TABLE");
        hiveTable.setDbName(catalogTable.dbName);
        hiveTable.setTableName(catalogTable.tableName);
        hiveTable.setCreateTime(0);
        hiveTable.setOwner("nobody");
        hiveTable.setLastAccessTime(0);
        hiveTable.setRetention(0);
        hiveTable.setSd(DSSHiveCatalogToHiveConverter.convertStorageDescriptor(catalogTable.sd));
        hiveTable.setPartitionKeys(DSSHiveCatalogToHiveConverter.convertFieldSchemaList(catalogTable.partitionKeys));
        hiveTable.setParameters(new HashMap());
        return hiveTable;
    }

    public static StorageDescriptor convertStorageDescriptor(DSSHiveCatalogTable.DSSHiveCatalogTableStorageDescriptor dssSD) {
        StorageDescriptor hiveSd = new StorageDescriptor();
        hiveSd.setCols(DSSHiveCatalogToHiveConverter.convertFieldSchemaList(dssSD.columns));
        hiveSd.setLocation(dssSD.location);
        hiveSd.setInputFormat(dssSD.inputFormat);
        hiveSd.setOutputFormat(dssSD.outputFormat);
        hiveSd.setParameters(new HashMap());
        SerDeInfo sdi = new SerDeInfo();
        sdi.setSerializationLib(dssSD.serdeName);
        sdi.setParameters(dssSD.serdeParams);
        hiveSd.setSerdeInfo(sdi);
        hiveSd.setSerdeInfoIsSet(true);
        return hiveSd;
    }

    public static Partition convertPartition(DSSHiveCatalogTable table, DSSHiveCatalogPartition partition) {
        Partition tgt = new Partition();
        tgt.setDbName(table.dbName);
        tgt.setParameters(new HashMap());
        tgt.setTableName(table.tableName);
        logger.info((Object)("Converting " + partition.hivePartitionName + " to values"));
        ArrayList<String> vals = new ArrayList<String>();
        for (String v : partition.hivePartitionName.split(",")) {
            String[] chunks = v.split("=");
            vals.add(chunks[1]);
        }
        tgt.setValues(vals);
        tgt.setValuesIsSet(true);
        StorageDescriptor sd = DSSHiveCatalogToHiveConverter.convertStorageDescriptor(table.sd);
        sd.setLocation(partition.location);
        tgt.setSd(sd);
        return tgt;
    }

    public static List<Partition> convertPartitions(DSSHiveCatalogTable table, List<DSSHiveCatalogPartition> catalogPartitions) {
        ArrayList target = Lists.newArrayList();
        for (DSSHiveCatalogPartition catalogPartition : catalogPartitions) {
            target.add(DSSHiveCatalogToHiveConverter.convertPartition(table, catalogPartition));
        }
        return target;
    }
}

