/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.server;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.exposition.ArbitraryYamlExposition;
import com.dataiku.dip.exposition.ClusterIPExposition;
import com.dataiku.dip.exposition.DockerDirectExposition;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.ExpositionAdapter;
import com.dataiku.dip.exposition.ExpositionMeta;
import com.dataiku.dip.exposition.ExpositionRegistry;
import com.dataiku.dip.exposition.GKEIngressExposition;
import com.dataiku.dip.exposition.IngressExposition;
import com.dataiku.dip.exposition.LoadBalancerExposition;
import com.dataiku.dip.exposition.LocalProcessExposition;
import com.dataiku.dip.exposition.NginxIngressExposition;
import com.dataiku.dip.exposition.NodePortExposition;
import com.dataiku.dip.exposition.PortForwardExposition;
import com.dataiku.dip.logging.MainLoggingConfiguratorBase;
import com.dataiku.dip.rpc.LocalBackendPrivilegedIntercomAPIClient;
import com.dataiku.dip.server.JettyUtils;
import com.dataiku.dip.util.ServletUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletHolder;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.ConnectionFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Connector;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.HttpConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.HttpConnectionFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Server;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.ServerConnector;
import com.dataiku.hproxy.server.Context;
import com.dataiku.hproxy.server.servlets.HiveExecutorServlet;
import com.dataiku.hproxy.server.servlets.PigCheckerServlet;
import com.dataiku.hproxy.server.servlets.PingServlet;
import jakarta.servlet.Servlet;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class HProxyRunner {
    public static void main(String[] args) throws IOException {
        try {
            HProxyRunner.doMain(args);
        }
        catch (Throwable e) {
            System.err.println("HProxy failed");
            e.printStackTrace(System.err);
            try {
                File runDir = new File(".").getAbsoluteFile();
                File errorFile = new File(runDir, "error.json");
                System.err.println("Dump error to " + errorFile.getAbsolutePath());
                JSON.prettyToFile((Object)new SerializedError(e, true), (File)errorFile);
            }
            catch (Throwable e2) {
                System.err.println("Failed to write error file");
                e2.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }

    private static void doMain(String[] args) throws Throwable {
        System.setProperty("DIP_HOME", System.getenv("DIP_HOME"));
        ApplicationConfigurator.autoconfigure();
        MainLoggingConfiguratorBase.loadMainLog4JProperties();
        final Logger logger = Logger.getLogger(HProxyRunner.class);
        logger.info((Object)"Loading logging settings");
        try {
            File installDir = new File(System.getenv("DKUINSTALLDIR"));
            File dataDir = new File(System.getenv("DIP_HOME"));
            MainLoggingConfiguratorBase.loadFile((File)DKUFileUtils.getWithin((File)installDir, (String[])new String[]{"resources", "logging", "dku-log4j.properties"}));
            MainLoggingConfiguratorBase.loadFile((File)DKUFileUtils.getWithin((File)dataDir, (String[])new String[]{"resources", "logging", "dku-log4j.properties"}));
            MainLoggingConfiguratorBase.loadFile((File)DKUFileUtils.getWithin((File)installDir, (String[])new String[]{"resources", "logging", "dku-hproxy-log4j.properties"}));
            MainLoggingConfiguratorBase.loadFile((File)DKUFileUtils.getWithin((File)dataDir, (String[])new String[]{"resources", "logging", "dku-hproxy-log4j.properties"}));
        }
        catch (Exception e) {
            logger.warn((Object)"failed to configure additional logging", (Throwable)e);
        }
        logger.info((Object)"Starting HProxy...");
        JSON.registerAdapter(Exposition.class, (Object)ExpositionAdapter.INSTANCE);
        ExpositionRegistry.register((ExpositionMeta)LocalProcessExposition.META);
        ExpositionRegistry.register((ExpositionMeta)DockerDirectExposition.META);
        ExpositionRegistry.register((ExpositionMeta)PortForwardExposition.META);
        ExpositionRegistry.register((ExpositionMeta)LoadBalancerExposition.META);
        ExpositionRegistry.register((ExpositionMeta)IngressExposition.META);
        ExpositionRegistry.register((ExpositionMeta)GKEIngressExposition.META);
        ExpositionRegistry.register((ExpositionMeta)NginxIngressExposition.META);
        ExpositionRegistry.register((ExpositionMeta)ClusterIPExposition.META);
        ExpositionRegistry.register((ExpositionMeta)NodePortExposition.META);
        ExpositionRegistry.register((ExpositionMeta)ArbitraryYamlExposition.META);
        logger.info((Object)"Initialize context");
        Context ctx = Context.create();
        new Thread("stdin-watcher"){
            {
                super(name);
                this.setDaemon(true);
            }

            @Override
            public void run() {
                try {
                    while (true) {
                        if (System.in.read() != -1) {
                            continue;
                        }
                        logger.warn((Object)"Standard input closed, exiting");
                        System.exit(0);
                    }
                }
                catch (IOException e) {
                    logger.warn((Object)"Error reading standard input, exiting", (Throwable)e);
                    System.exit(1);
                    return;
                }
            }
        }.start();
        Server server = new Server(0);
        HttpConfiguration httpConfig = JettyUtils.createHttpConfiguration();
        HttpConnectionFactory http = new HttpConnectionFactory(httpConfig);
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{http});
        connector.setIdleTimeout(-1L);
        server.setConnectors((Connector[])new ServerConnector[]{connector});
        ServletContextHandler sch = ServletUtils.createServletContext((int)200000000, (String)"/");
        JettyUtils.addHandlers((Server)server, (ServletContextHandler)sch);
        sch.addServlet(new ServletHolder((Servlet)new PingServlet(ctx)), "/hproxy/*");
        try {
            if (ctx.isPigAvailable()) {
                logger.info((Object)"HProxy-Pig servlet initialized");
                sch.addServlet(new ServletHolder((Servlet)new PigCheckerServlet(ctx)), "/pig/*");
            } else {
                logger.warn((Object)"HProxy-Pig servlet not started because Pig is not available");
            }
            if (ctx.isHiveAvailable()) {
                logger.info((Object)"HProxy-Hive servlet initialized");
                sch.addServlet(new ServletHolder((Servlet)new HiveExecutorServlet(ctx)), "/hive/*");
            } else {
                logger.warn((Object)"HProxy-Hive servlet not started because Hive is not available");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Servlet creation failed, killing hproxy", (Throwable)e);
            System.exit(1);
        }
        server.start();
        int port = connector.getLocalPort();
        logger.info((Object)("Kernel started on port " + port + ", registering it"));
        String kernelId = System.getenv("DKU_HPROXY_ID");
        try (LocalBackendPrivilegedIntercomAPIClient client = new LocalBackendPrivilegedIntercomAPIClient();){
            client.postFormToJSON("dip/api/pintercom/recipes/hive-kernel-register", Void.class, new Object[]{"kernelId", kernelId, "port", Integer.toString(port)});
        }
        catch (Exception e) {
            logger.info((Object)"Registration failed, aborting", (Throwable)e);
            System.exit(1);
        }
        server.join();
    }
}

