/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.server.servlets;

import com.dataiku.hproxy.model.JsonifiableError;
import com.dataiku.hproxy.server.Context;
import com.google.gson.Gson;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class BaseServlet
extends HttpServlet {
    private static final long serialVersionUID = 343705949025493678L;
    private static Logger logger = Logger.getLogger(BaseServlet.class);
    private Gson gson = new Gson();
    private Context ctx;

    protected BaseServlet(Context ctx) {
        this.ctx = ctx;
    }

    protected void writeJSON(HttpServletResponse resp, Object o) throws IOException {
        resp.setContentType("application/json; charset=UTF-8");
        resp.getWriter().write(new Gson().toJson(o));
    }

    protected void sendError(HttpServletResponse resp, Throwable error) throws IOException {
        logger.info((Object)"Call failed", error);
        resp.setStatus(500);
        resp.setContentType("application/json");
        resp.getWriter().write(new Gson().toJson((Object)new JsonifiableError(error)));
    }

    protected abstract void serviceCall(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String secretKey = this.ctx.getSecretKey();
        String receivedSecretKey = req.getHeader("X-DKU-IPythonSharedSecret");
        if (StringUtils.isBlank((String)receivedSecretKey) || !StringUtils.equals((String)secretKey, (String)receivedSecretKey)) {
            resp.sendError(403);
            return;
        }
        String path = req.getPathInfo();
        long startTime = System.currentTimeMillis();
        logger.debug((Object)("Received command : " + path));
        try {
            this.serviceCall(req, resp);
        }
        finally {
            long endTime = System.currentTimeMillis();
            logger.debug((Object)("Command " + path + " processed in " + (endTime - startTime) + "ms"));
        }
    }

    protected String getParameter(HttpServletRequest req, String name) {
        String val = req.getParameter(name);
        if (val != null) {
            return val;
        }
        throw new RuntimeException("Missing parameter \"" + name + "\"");
    }

    protected <T> T getParameter(HttpServletRequest req, String name, Class<T> type) {
        String val = req.getParameter(name);
        if (val != null) {
            return (T)this.gson.fromJson(req.getParameter(name), type);
        }
        throw new RuntimeException("Missing parameter \"" + name + "\"");
    }

    protected Context getContext() {
        return this.ctx;
    }
}

