/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.streaming;

import java.io.Serializable;
import net.snowflake.ingest.SimpleIngestManager;
import net.snowflake.ingest.connection.IngestStatus;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.ServerConnection;
import net.snowflake.spark.snowflake.io.CloudStorage;
import net.snowflake.spark.snowflake.streaming.IngestContextManager$;
import net.snowflake.spark.snowflake.streaming.IngestedFileList;
import net.snowflake.spark.snowflake.streaming.SnowflakeIngestConnector$;
import scala.Function0;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001\u0002\u000f\u001e\u0001\u001dB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"A!\n\u0001B\u0001B\u0003%1\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003S\u0011\u00151\u0006\u0001\"\u0001X\u0011\u001dq\u0006A1A\u0005\u0002}Caa\u0019\u0001!\u0002\u0013\u0001\u0007b\u00023\u0001\u0005\u0004%\ta\u0018\u0005\u0007K\u0002\u0001\u000b\u0011\u00021\t\u000f\u0019\u0004!\u0019!C\u0001O\"11\u000e\u0001Q\u0001\n!D\u0001\u0002\u001c\u0001\t\u0006\u0004%\u0019!\u001c\u0005\bi\u0002\u0001\r\u0011\"\u0003v\u0011\u001dI\b\u00011A\u0005\niDq!!\u0001\u0001A\u0003&a\u000fC\u0005\u0002\u0004\u0001\u0011\r\u0011\"\u0003\u0002\u0006!A\u0011Q\u0002\u0001!\u0002\u0013\t9\u0001\u0003\u0006\u0002\u0010\u0001A)\u0019!C\u0005\u0003#A\u0001\"!\u0010\u0001\u0001\u0004%I!\u001e\u0005\n\u0003\u007f\u0001\u0001\u0019!C\u0005\u0003\u0003Bq!!\u0012\u0001A\u0003&a\u000fC\u0005\u0002H\u0001\u0011\r\u0011\"\u0003\u0002J!A\u0011q\u000b\u0001!\u0002\u0013\tY\u0005C\u0004\u0002Z\u0001!\t!a\u0017\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002f!9\u0011q\r\u0001\u0005\u0002\u0005\u0015\u0004bBA5\u0001\u0011%\u00111\u000e\u0002\u0017':|wO\u001a7bW\u0016LenZ3tiN+'O^5dK*\u0011adH\u0001\ngR\u0014X-Y7j]\u001eT!\u0001I\u0011\u0002\u0013Mtwn\u001e4mC.,'B\u0001\u0012$\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001CEC\u0001&\u0003\rqW\r^\u0002\u0001'\t\u0001\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\u0006a\u0006\u0014\u0018-\u001c\t\u0003ayr!!\r\u001f\u000f\u0005IZdBA\u001a;\u001d\t!\u0014H\u0004\u00026q5\taG\u0003\u00028M\u00051AH]8pizJ\u0011!J\u0005\u0003A\u0011J!AI\u0012\n\u0005\u0001\n\u0013BA\u001f \u0003)\u0001\u0016M]1nKR,'o]\u0005\u0003\u007f\u0001\u0013\u0001#T3sO\u0016$\u0007+\u0019:b[\u0016$XM]:\u000b\u0005uz\u0012\u0001\u00039ja\u0016t\u0015-\\3\u0011\u0005\r;eB\u0001#F!\t)$&\u0003\u0002GU\u00051\u0001K]3eK\u001aL!\u0001S%\u0003\rM#(/\u001b8h\u0015\t1%&A\u0004ti>\u0014\u0018mZ3\u0011\u00051{U\"A'\u000b\u00059{\u0012AA5p\u0013\t\u0001VJ\u0001\u0007DY>,Hm\u0015;pe\u0006<W-\u0001\u0003d_:t\u0007CA*U\u001b\u0005y\u0012BA+ \u0005A\u0019VM\u001d<fe\u000e{gN\\3di&|g.\u0001\u0004=S:LGO\u0010\u000b\u00061j[F,\u0018\t\u00033\u0002i\u0011!\b\u0005\u0006]\u0015\u0001\ra\f\u0005\u0006\u0003\u0016\u0001\rA\u0011\u0005\u0006\u0015\u0016\u0001\ra\u0013\u0005\u0006#\u0016\u0001\rAU\u0001\u000b'2+U\tU0U\u00136+U#\u00011\u0011\u0005%\n\u0017B\u00012+\u0005\u0011auN\\4\u0002\u0017McU)\u0012)`)&kU\tI\u0001\u0013\u0011&\u001bFk\u0014*Z?\u000eCUiQ&`)&kU)A\nI\u0013N#vJU-`\u0007\"+5iS0U\u00136+\u0005%A\u000eX\u0003&#\u0016JT$`)&kUiX(O?R+%+T%O\u0003RKuJT\u000b\u0002QB\u0011\u0011&[\u0005\u0003U*\u00121!\u00138u\u0003q9\u0016)\u0013+J\u001d\u001e{F+S'F?>su\fV#S\u001b&s\u0015\tV%P\u001d\u0002\nQ\"\u001b8hKN$X*\u00198bO\u0016\u0014X#\u00018\u0011\u0005=\u0014X\"\u00019\u000b\u0005E\u001c\u0013AB5oO\u0016\u001cH/\u0003\u0002ta\n\u00192+[7qY\u0016LenZ3ti6\u000bg.Y4fe\u0006Ian\u001c;DY>\u001cX\rZ\u000b\u0002mB\u0011\u0011f^\u0005\u0003q*\u0012qAQ8pY\u0016\fg.A\u0007o_R\u001cEn\\:fI~#S-\u001d\u000b\u0003wz\u0004\"!\u000b?\n\u0005uT#\u0001B+oSRDqa \b\u0002\u0002\u0003\u0007a/A\u0002yIE\n!B\\8u\u00072|7/\u001a3!\u0003AIgnZ3ti\u0016$g)\u001b7f\u0019&\u001cH/\u0006\u0002\u0002\bA\u0019\u0011,!\u0003\n\u0007\u0005-QD\u0001\tJ]\u001e,7\u000f^3e\r&dW\rT5ti\u0006\t\u0012N\\4fgR,GMR5mK2K7\u000f\u001e\u0011\u0002\u000f\rDWmY6feV\u0011\u00111\u0003\t\u0006S\u0005U\u0011\u0011D\u0005\u0004\u0003/Q#!\u0003$v]\u000e$\u0018n\u001c81!\u0019\tY\"!\n\u0002,9!\u0011QDA\u0011\u001d\r)\u0014qD\u0005\u0002W%\u0019\u00111\u0005\u0016\u0002\u000fA\f7m[1hK&!\u0011qEA\u0015\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\r\"\u0006\u0005\u0004*\u0003[\u0011\u0015\u0011G\u0005\u0004\u0003_Q#A\u0002+va2,'\u0007\u0005\u0003\u00024\u0005eRBAA\u001b\u0015\r\t9\u0004]\u0001\u000bG>tg.Z2uS>t\u0017\u0002BA\u001e\u0003k\u0011A\"\u00138hKN$8\u000b^1ukN\f1\u0002]5qK\u0012\u0013x\u000e\u001d9fI\u0006y\u0001/\u001b9f\tJ|\u0007\u000f]3e?\u0012*\u0017\u000fF\u0002|\u0003\u0007Bqa \u000b\u0002\u0002\u0003\u0007a/\u0001\u0007qSB,GI]8qa\u0016$\u0007%A\u0004qe>\u001cWm]:\u0016\u0005\u0005-\u0003#BA'\u0003'ZXBAA(\u0015\r\t\tFK\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA+\u0003\u001f\u0012aAR;ukJ,\u0017\u0001\u00039s_\u000e,7o\u001d\u0011\u0002\u0017%tw-Z:u\r&dWm\u001d\u000b\u0004w\u0006u\u0003bBA01\u0001\u0007\u0011\u0011M\u0001\u0005Y&\u001cH\u000fE\u0003\u0002\u001c\u0005\u0015\")\u0001\u0005dY\u0016\fg.\u00117m)\u0005Y\u0018!B2m_N,\u0017\u0001B5oSR$\"!a\u0002")
public class SnowflakeIngestService {
    private SimpleIngestManager ingestManager;
    private Function0<List<Tuple2<String, IngestStatus>>> checker;
    private Parameters.MergedParameters param;
    private final String pipeName;
    private final CloudStorage storage;
    private final ServerConnection conn;
    private final long SLEEP_TIME;
    private final long HISTORY_CHECK_TIME;
    private final int WAITING_TIME_ON_TERMINATION;
    private boolean notClosed;
    private final IngestedFileList ingestedFileList;
    private boolean pipeDropped;
    private final Future<BoxedUnit> process;
    private volatile byte bitmap$0;

    public long SLEEP_TIME() {
        return this.SLEEP_TIME;
    }

    public long HISTORY_CHECK_TIME() {
        return this.HISTORY_CHECK_TIME;
    }

    public int WAITING_TIME_ON_TERMINATION() {
        return this.WAITING_TIME_ON_TERMINATION;
    }

    private SimpleIngestManager ingestManager$lzycompute() {
        SnowflakeIngestService snowflakeIngestService = this;
        synchronized (snowflakeIngestService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.ingestManager = SnowflakeIngestConnector$.MODULE$.createIngestManager(this.param, this.pipeName);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.param = null;
        return this.ingestManager;
    }

    public SimpleIngestManager ingestManager() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.ingestManager$lzycompute() : this.ingestManager;
    }

    private boolean notClosed() {
        return this.notClosed;
    }

    private void notClosed_$eq(boolean x$1) {
        this.notClosed = x$1;
    }

    private IngestedFileList ingestedFileList() {
        return this.ingestedFileList;
    }

    private Function0<List<Tuple2<String, IngestStatus>>> checker$lzycompute() {
        SnowflakeIngestService snowflakeIngestService = this;
        synchronized (snowflakeIngestService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.checker = SnowflakeIngestConnector$.MODULE$.createHistoryChecker(this.ingestManager());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.checker;
    }

    private Function0<List<Tuple2<String, IngestStatus>>> checker() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.checker$lzycompute() : this.checker;
    }

    private boolean pipeDropped() {
        return this.pipeDropped;
    }

    private void pipeDropped_$eq(boolean x$1) {
        this.pipeDropped = x$1;
    }

    private Future<BoxedUnit> process() {
        return this.process;
    }

    public void ingestFiles(List<String> list) {
        SnowflakeIngestConnector$.MODULE$.ingestFiles(list, this.ingestManager());
        this.ingestedFileList().addFiles(list);
    }

    public void cleanAll() {
        while (this.ingestedFileList().nonEmpty()) {
            Thread.sleep(this.SLEEP_TIME());
            long time = System.currentTimeMillis();
            if (time - BoxesRunTime.unboxToLong((Object)this.ingestedFileList().getFirstTimeStamp().get()) > 600000L) {
                this.ingestedFileList().checkResponseList(SnowflakeIngestConnector$.MODULE$.checkHistoryByRange(this.ingestManager(), BoxesRunTime.unboxToLong((Object)this.ingestedFileList().getFirstTimeStamp().get()), time));
                continue;
            }
            this.ingestedFileList().checkResponseList((List<Tuple2<String, IngestStatus>>)((List)this.checker().apply()));
        }
        DefaultJDBCWrapper.DataBaseOperations qual$1 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(this.conn);
        String x$1 = this.pipeName;
        boolean x$2 = qual$1.dropPipe$default$2();
        qual$1.dropPipe(x$1, x$2);
        this.ingestedFileList().remove();
        this.pipeDropped_$eq(true);
    }

    public void close() {
        long ct = System.currentTimeMillis();
        IngestContextManager$.MODULE$.logger().debug((Object)"closing ingest service");
        this.notClosed_$eq(false);
        Await$.MODULE$.result(this.process(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(this.WAITING_TIME_ON_TERMINATION())).minutes());
        if (!this.pipeDropped()) {
            IngestContextManager$.MODULE$.logger().error((Object)new StringBuilder(60).append("closing ingest service time out, please drop pipe: ").append(this.pipeName).append(" manually").toString());
        }
        IngestContextManager$.MODULE$.logger().debug((Object)new StringBuilder(23).append("ingest service closed: ").append((double)(System.currentTimeMillis() - ct) / 1000.0).toString());
    }

    private IngestedFileList init() {
        return IngestContextManager$.MODULE$.readIngestList(this.storage, this.conn);
    }

    public SnowflakeIngestService(Parameters.MergedParameters param, String pipeName, CloudStorage storage, ServerConnection conn) {
        this.param = param;
        this.pipeName = pipeName;
        this.storage = storage;
        this.conn = conn;
        this.SLEEP_TIME = 60000L;
        this.HISTORY_CHECK_TIME = 3600000L;
        this.WAITING_TIME_ON_TERMINATION = 10;
        this.notClosed = true;
        this.ingestedFileList = this.init();
        this.pipeDropped = false;
        this.process = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            while (this.notClosed()) {
                Thread.sleep(this.SLEEP_TIME());
                long time = System.currentTimeMillis();
                this.ingestedFileList().checkResponseList((List<Tuple2<String, IngestStatus>>)((List)this.checker().apply()));
                if (!this.ingestedFileList().getFirstTimeStamp().isDefined() || time - BoxesRunTime.unboxToLong((Object)this.ingestedFileList().getFirstTimeStamp().get()) <= this.HISTORY_CHECK_TIME()) continue;
                this.ingestedFileList().checkResponseList(SnowflakeIngestConnector$.MODULE$.checkHistoryByRange(this.ingestManager(), BoxesRunTime.unboxToLong((Object)this.ingestedFileList().getFirstTimeStamp().get()), time));
            }
            this.cleanAll();
        }, ExecutionContext.Implicits$.MODULE$.global());
    }
}

