/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.StdDataikuSparkContext$;
import com.dataiku.dip.spark.package$;
import com.dataiku.dip.sql.SnowflakeSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.security.PrivateKey;
import java.util.Base64;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class SnowflakeFastpathSupport$ {
    public static SnowflakeFastpathSupport$ MODULE$;
    private final String SnowflakeSourceFormat;
    private final SnowflakeSQLDialect SnowflakeSqlDialect;
    private final Logger logger;

    static {
        new SnowflakeFastpathSupport$();
    }

    public String SnowflakeSourceFormat() {
        return this.SnowflakeSourceFormat;
    }

    public SnowflakeSQLDialect SnowflakeSqlDialect() {
        return this.SnowflakeSqlDialect;
    }

    private final String getOrElseFromJava(String value, Function0<String> function0) {
        Some some;
        String realValue;
        Option option = Option$.MODULE$.apply((Object)value);
        if (option instanceof Some && !(realValue = (String)(some = (Some)option).value()).trim().isEmpty()) {
            return realValue;
        }
        return (String)function0.apply();
    }

    private final String getOrElseFromJava$default$2() {
        return "";
    }

    private String getSchema(String datasetSchema, SnowflakeConnection.Params connectionParams, String connectionName) {
        return this.getOrElseFromJava(datasetSchema, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            MODULE$.logger().info((Object)new StringBuilder(81).append("Target dataset schema blank, trying to use the schema defined in the connection: ").append(connectionParams$1.defaultSchema).toString());
            return MODULE$.getOrElseFromJava(connectionParams$1.defaultSchema, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                Option option = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(connectionParams$1.properties).find((Function1 & Serializable & scala.Serializable)property -> BoxesRunTime.boxToBoolean((boolean)SnowflakeFastpathSupport$.$anonfun$getSchema$3(property)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    AbstractSQLConnection.CustomDatabaseProperty property2 = (AbstractSQLConnection.CustomDatabaseProperty)some.value();
                    if (!property2.value.trim().isEmpty()) {
                        MODULE$.logger().info((Object)new StringBuilder(101).append("Target dataset and connection schema blank, setting schema to ").append(property2.value).append(" ").append("as found in connection JDBC properties").toString());
                        return property2.value;
                    }
                }
                throw new IllegalArgumentException(new StringBuilder(62).append("Schema must be set in either the target dataset or connection ").append(connectionName).toString());
            });
        });
    }

    private String getCatalog(String datasetCatalog, SnowflakeConnection.Params connectionParams, String connectionName) {
        return this.getOrElseFromJava(datasetCatalog, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            MODULE$.logger().info((Object)new StringBuilder(83).append("Target dataset catalog blank, trying to use the catalog defined in the connection: ").append(connectionParams$2.db).toString());
            return MODULE$.getOrElseFromJava(connectionParams$2.db, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                Option option = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(connectionParams$2.properties).find((Function1 & Serializable & scala.Serializable)property -> BoxesRunTime.boxToBoolean((boolean)SnowflakeFastpathSupport$.$anonfun$getCatalog$3(property)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    AbstractSQLConnection.CustomDatabaseProperty property2 = (AbstractSQLConnection.CustomDatabaseProperty)some.value();
                    if (!property2.value.trim().isEmpty()) {
                        MODULE$.logger().info((Object)new StringBuilder(103).append("Target dataset and connection catalog blank, setting catalog to ").append(property2.value).append(" ").append("as found in connection JDBC properties").toString());
                        return property2.value;
                    }
                }
                throw new IllegalArgumentException(new StringBuilder(63).append("Catalog must be set in either the target dataset or connection ").append(connectionName).toString());
            });
        });
    }

    private VariablesContext getVariableContext(String projectKey) {
        Some some;
        String key;
        Option option = Option$.MODULE$.apply((Object)projectKey);
        if (option instanceof Some && !(key = (String)(some = (Some)option).value()).trim().isEmpty() && !"__DKU_PROJECT_KEY__".equals(key.trim())) {
            return ((VariablesService)SpringUtils.getBean(VariablesService.class)).getForProject(key);
        }
        this.logger().info((Object)new StringBuilder(43).append("No valid project key (").append(projectKey).append("), use global context").toString());
        return ((VariablesService)SpringUtils.getBean(VariablesService.class)).getForGlobal();
    }

    private PrivateKey getPrivateKey(byte[] key, String passphrase) {
        PrivateKeyInfo privateKeyInfo;
        PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(new ByteArrayInputStream(key)));
        Object pemObject = pemParser.readObject();
        Object object = pemObject;
        if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
            PKCS8EncryptedPrivateKeyInfo pKCS8EncryptedPrivateKeyInfo = (PKCS8EncryptedPrivateKeyInfo)object;
            InputDecryptorProvider decryptorProvider = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(passphrase.toCharArray());
            privateKeyInfo = pKCS8EncryptedPrivateKeyInfo.decryptPrivateKeyInfo(decryptorProvider);
        } else if (object instanceof PrivateKeyInfo) {
            PrivateKeyInfo privateKeyInfo2;
            privateKeyInfo = privateKeyInfo2 = (PrivateKeyInfo)object;
        } else {
            throw new IllegalArgumentException("Unsupported key format");
        }
        PrivateKeyInfo privateKeyInfo3 = privateKeyInfo;
        pemParser.close();
        return new JcaPEMKeyConverter().getPrivateKey(privateKeyInfo3);
    }

    private String getEncoded(PrivateKey privateKey) {
        return Base64.getMimeEncoder(64, "\n".getBytes()).encodeToString(privateKey.getEncoded());
    }

    public Map<String, String> getConnectionOptions(String connectionName, String catalog, String schema, String projectKey) {
        VariablesContext variableContext = this.getVariableContext(projectKey);
        SnowflakeConnection snowflakeConnection = (SnowflakeConnection)ConnectionsDAO.get().getConnection((AuthCtx)DSSAuthCtx.newNone(), connectionName);
        SnowflakeConnection.Params connectionParams = snowflakeConnection.params;
        Map options = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sfURL"), (Object)this.getOrElseFromJava(connectionParams.host, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.getOrElseFromJava$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sfDatabase"), (Object)this.getCatalog(catalog, connectionParams, connectionName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sfSchema"), (Object)this.getSchema(schema, connectionParams, connectionName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sfWarehouse"), (Object)this.getOrElseFromJava(connectionParams.warehouse, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.getOrElseFromJava$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sfRole"), (Object)this.getOrElseFromJava(connectionParams.role, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.getOrElseFromJava$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"column_mapping"), (Object)"name"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"keep_column_case"), (Object)"on")}));
        List customParams = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(snowflakeConnection.params.properties).asScala()).toList();
        options = options.$plus$plus((GenTraversableOnce)((TraversableOnce)customParams.map((Function1 & Serializable & scala.Serializable)t -> new Tuple2((Object)t.name, (Object)t.value), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        SnowflakeConnection.SerializableSnowflakeCredentials creds = (SnowflakeConnection.SerializableSnowflakeCredentials)snowflakeConnection.getFullyResolvedCredentials_sqlLike(new ConnectionWithBasicCredential.CredentialResolutionContext((AuthCtx)DSSAuthCtx.newNone(), null), SnowflakeConnection.SerializableSnowflakeCredentials.class);
        SnowflakeConnection.AuthType authType = creds.authType;
        options = SnowflakeConnection.AuthType.OAUTH2_APP.equals(authType) ? options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sfUser"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sfAuthenticator"), (Object)"oauth"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sfToken"), (Object)creds.oauth2AccessToken)})) : (SnowflakeConnection.AuthType.KEY_PAIR.equals(authType) ? options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sfUser"), (Object)creds.user), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pem_private_key"), (Object)this.getEncoded(this.getPrivateKey(Base64.getDecoder().decode(creds.privateKeyB64), creds.privateKeyPassword))), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])) : options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sfUser"), (Object)this.getOrElseFromJava(creds.user, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.getOrElseFromJava$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sfPassword"), (Object)this.getOrElseFromJava(creds.password, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.getOrElseFromJava$default$2())), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])));
        return (Map)options.transform((Function2 & Serializable & scala.Serializable)(x$1, value) -> variableContext.expand(value), Map$.MODULE$.canBuildFrom());
    }

    public void saveSnowflakeDataset(AbstractSQLTableDatasetHandler datasetHandler, org.apache.spark.sql.Dataset<Row> dataFrame, String partition, Enumeration.Value writeMode, String apiTicket) {
        Dataset dataset = datasetHandler.getDataset();
        StdDataikuSparkContext$.MODULE$.executeCommand("datasets/prepare-sql-table-for-write/", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"projectKey"), (Object)dataset.getProjectKey()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetName"), (Object)dataset.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)partition), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"writeMode"), (Object)writeMode.toString())}))), apiTicket, ClassTag$.MODULE$.apply(InfoMessage.InfoMessages.class));
        ObjectRef df = ObjectRef.create(dataFrame);
        PartitioningScheme partitioningSchema = dataset.getPartitioningSchema();
        if (partitioningSchema.isPartitioned() && dataFrame.schema().length() != dataset.getSchema().columns.size()) {
            Partition targetPartition = PartitionFactory.fromIdentifier((PartitioningScheme)partitioningSchema, (String)partition);
            JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(targetPartition.getDimensionValues()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                SnowflakeFastpathSupport$.$anonfun$saveSnowflakeDataset$1(dataset, df, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        try {
            ((org.apache.spark.sql.Dataset)df.elem).write().format(this.SnowflakeSourceFormat()).options(this.getConnectionOptions(datasetHandler.getConnectionName(), datasetHandler.getResolvedTable().getCatalog(), datasetHandler.getResolvedTable().getSchemaNullIfBlank(), dataset.getProjectKey())).option("dbtable", this.SnowflakeSqlDialect().quoteIdentifier(datasetHandler.getResolvedTable().getTable())).mode(SaveMode.Append).save();
        }
        catch (NoSuchElementException ex) {
            if (ex.getMessage().contains("head of empty list")) {
                String identifier = partitioningSchema.isPartitioned() ? new StringBuilder(14).append("partition ").append(partition).append(" of ").append(dataset.getFullName()).toString() : dataset.getFullName();
                this.logger().info((Object)new StringBuilder(112).append("Caught NoSuchElementException when writing ").append(identifier).append(" to Snowflake, ").append("ignoring since it probably means the dataset was empty").toString());
            }
            throw ex;
        }
    }

    private Logger logger() {
        return this.logger;
    }

    public static final /* synthetic */ boolean $anonfun$getSchema$3(AbstractSQLConnection.CustomDatabaseProperty property) {
        return "schema".equals(property.name);
    }

    public static final /* synthetic */ boolean $anonfun$getCatalog$3(AbstractSQLConnection.CustomDatabaseProperty property) {
        return "db".equals(property.name);
    }

    public static final /* synthetic */ void $anonfun$saveSnowflakeDataset$1(Dataset dataset$1, ObjectRef df$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String dimensionName = (String)tuple2._1();
            DimensionValue dimensionValue = (DimensionValue)tuple2._2();
            if (dimensionName != null) {
                String string = dimensionName;
                if (dimensionValue != null) {
                    DimensionValue dimensionValue2 = dimensionValue;
                    if (!dataset$1.getSchema().columns.contains(string)) {
                        SchemaColumn partitionColumn = dataset$1.getSchema().getColumn(string);
                        if (partitionColumn == null) {
                            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, new StringBuilder(53).append("Dataset '").append(dataset$1.getName()).append("' does not contain the partitioning column: ").append(string).toString());
                        }
                        String partitionValue = ExpressionUtils.getStringForDimensionValue((DimensionValue)dimensionValue2, (Type)partitionColumn.getType());
                        DataType dataType = package$.MODULE$.dkuToSpark(partitionColumn).dataType();
                        df$1.elem = ((org.apache.spark.sql.Dataset)df$1.elem).withColumn(string, functions$.MODULE$.lit((Object)partitionValue).cast(dataType));
                        return;
                    }
                    return;
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private SnowflakeFastpathSupport$() {
        MODULE$ = this;
        this.SnowflakeSourceFormat = "net.snowflake.spark.snowflake";
        this.SnowflakeSqlDialect = new SnowflakeSQLDialect();
        this.logger = Logger.getLogger((String)"dku.spark.context");
    }
}

