/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.commons.beanutils;

import com.dataiku.dss.shadelib.org.apache.commons.beanutils.PropertyUtils;
import com.dataiku.dss.shadelib.org.apache.commons.collections.Closure;
import com.dataiku.dss.shadelib.org.apache.commons.logging.Log;
import com.dataiku.dss.shadelib.org.apache.commons.logging.LogFactory;
import java.lang.reflect.InvocationTargetException;

public class BeanPropertyValueChangeClosure
implements Closure {
    private final Log log = LogFactory.getLog(this.getClass());
    private final String propertyName;
    private final Object propertyValue;
    private final boolean ignoreNull;

    public BeanPropertyValueChangeClosure(String propertyName, Object propertyValue) {
        this(propertyName, propertyValue, false);
    }

    public BeanPropertyValueChangeClosure(String propertyName, Object propertyValue, boolean ignoreNull) {
        if (propertyName == null || propertyName.length() <= 0) {
            throw new IllegalArgumentException("propertyName cannot be null or empty");
        }
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
        this.ignoreNull = ignoreNull;
    }

    public void execute(Object object) {
        try {
            PropertyUtils.setProperty(object, this.propertyName, this.propertyValue);
        }
        catch (IllegalArgumentException e) {
            String errorMsg = "Unable to execute Closure. Null value encountered in property path...";
            if (!this.ignoreNull) {
                IllegalArgumentException iae = new IllegalArgumentException("Unable to execute Closure. Null value encountered in property path...", e);
                throw iae;
            }
            this.log.warn("WARNING: Unable to execute Closure. Null value encountered in property path..." + e);
        }
        catch (IllegalAccessException e) {
            String errorMsg = "Unable to access the property provided.";
            throw new IllegalArgumentException("Unable to access the property provided.", e);
        }
        catch (InvocationTargetException e) {
            String errorMsg = "Exception occurred in property's getter";
            throw new IllegalArgumentException("Exception occurred in property's getter", e);
        }
        catch (NoSuchMethodException e) {
            String errorMsg = "Property not found";
            throw new IllegalArgumentException("Property not found", e);
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getPropertyValue() {
        return this.propertyValue;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }
}

