/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.commons.configuration2.spring;

import com.dataiku.dss.shadelib.org.apache.commons.configuration2.CompositeConfiguration;
import com.dataiku.dss.shadelib.org.apache.commons.configuration2.Configuration;
import com.dataiku.dss.shadelib.org.apache.commons.configuration2.ConfigurationConverter;
import com.dataiku.dss.shadelib.org.apache.commons.configuration2.builder.fluent.Configurations;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.ArrayUtils;
import java.util.Properties;
import java.util.stream.Stream;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class ConfigurationPropertiesFactoryBean
implements InitializingBean,
FactoryBean<Properties> {
    private CompositeConfiguration compositeConfiguration;
    private Configuration[] configurations;
    private Resource[] locations;
    private boolean throwExceptionOnMissing = true;

    private static <T> T[] defensiveCopy(T[] src) {
        return src != null ? (Object[])src.clone() : null;
    }

    public ConfigurationPropertiesFactoryBean() {
    }

    public ConfigurationPropertiesFactoryBean(Configuration configuration) {
        Assert.notNull((Object)configuration, (String)"configuration");
        this.compositeConfiguration = new CompositeConfiguration(configuration);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.compositeConfiguration == null && ArrayUtils.isEmpty(this.configurations) && ArrayUtils.isEmpty(this.locations)) {
            throw new IllegalArgumentException("no configuration object or location specified");
        }
        if (this.compositeConfiguration == null) {
            this.compositeConfiguration = new CompositeConfiguration();
        }
        this.compositeConfiguration.setThrowExceptionOnMissing(this.throwExceptionOnMissing);
        if (this.configurations != null) {
            Stream.of(this.configurations).forEach(this.compositeConfiguration::addConfiguration);
        }
        if (this.locations != null) {
            for (Resource location : this.locations) {
                this.compositeConfiguration.addConfiguration(new Configurations().properties(location.getURL()));
            }
        }
    }

    public CompositeConfiguration getConfiguration() {
        return this.compositeConfiguration;
    }

    public Configuration[] getConfigurations() {
        return ConfigurationPropertiesFactoryBean.defensiveCopy(this.configurations);
    }

    public Resource[] getLocations() {
        return ConfigurationPropertiesFactoryBean.defensiveCopy(this.locations);
    }

    public Properties getObject() throws Exception {
        return this.compositeConfiguration != null ? ConfigurationConverter.getProperties(this.compositeConfiguration) : null;
    }

    public Class<?> getObjectType() {
        return Properties.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isThrowExceptionOnMissing() {
        return this.throwExceptionOnMissing;
    }

    public void setConfigurations(Configuration ... configurations) {
        this.configurations = ConfigurationPropertiesFactoryBean.defensiveCopy(configurations);
    }

    public void setLocations(Resource ... locations) {
        this.locations = ConfigurationPropertiesFactoryBean.defensiveCopy(locations);
    }

    public void setThrowExceptionOnMissing(boolean throwExceptionOnMissing) {
        this.throwExceptionOnMissing = throwExceptionOnMissing;
    }
}

