/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.codecs;

import com.dataiku.dss.shadelib.org.apache.lucene.codecs.KnnFieldVectorsWriter;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.KnnVectorsWriter;
import com.dataiku.dss.shadelib.org.apache.lucene.index.ByteVectorValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.DocsWithFieldSet;
import com.dataiku.dss.shadelib.org.apache.lucene.index.FieldInfo;
import com.dataiku.dss.shadelib.org.apache.lucene.index.FloatVectorValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.MergeState;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Sorter;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DocIdSetIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.VectorScorer;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ArrayUtil;
import com.dataiku.dss.shadelib.org.apache.lucene.util.RamUsageEstimator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class BufferingKnnVectorsWriter
extends KnnVectorsWriter {
    private final List<FieldWriter<?>> fields = new ArrayList();

    protected BufferingKnnVectorsWriter() {
    }

    @Override
    public KnnFieldVectorsWriter<?> addField(final FieldInfo fieldInfo) throws IOException {
        FieldWriter<Object[]> newField;
        switch (fieldInfo.getVectorEncoding()) {
            case FLOAT32: {
                newField = new FieldWriter<float[]>(fieldInfo){

                    @Override
                    public float[] copyValue(float[] vectorValue) {
                        return ArrayUtil.copyOfSubArray(vectorValue, 0, fieldInfo.getVectorDimension());
                    }
                };
                break;
            }
            case BYTE: {
                newField = new FieldWriter<byte[]>(fieldInfo){

                    @Override
                    public byte[] copyValue(byte[] vectorValue) {
                        return ArrayUtil.copyOfSubArray(vectorValue, 0, fieldInfo.getVectorDimension());
                    }
                };
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.fields.add(newField);
        return newField;
    }

    @Override
    public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
        for (FieldWriter<?> fieldData : this.fields) {
            switch (fieldData.fieldInfo.getVectorEncoding()) {
                case FLOAT32: {
                    BufferedFloatVectorValues bufferedFloatVectorValues = new BufferedFloatVectorValues(fieldData.docsWithField, fieldData.vectors, fieldData.fieldInfo.getVectorDimension());
                    FloatVectorValues floatVectorValues = sortMap != null ? new SortingFloatVectorValues(bufferedFloatVectorValues, sortMap) : bufferedFloatVectorValues;
                    this.writeField(fieldData.fieldInfo, floatVectorValues, maxDoc);
                    break;
                }
                case BYTE: {
                    BufferedByteVectorValues bufferedByteVectorValues = new BufferedByteVectorValues(fieldData.docsWithField, fieldData.vectors, fieldData.fieldInfo.getVectorDimension());
                    ByteVectorValues byteVectorValues = sortMap != null ? new SortingByteVectorValues(bufferedByteVectorValues, sortMap) : bufferedByteVectorValues;
                    this.writeField(fieldData.fieldInfo, byteVectorValues, maxDoc);
                }
            }
        }
    }

    @Override
    public long ramBytesUsed() {
        long total = 0L;
        for (FieldWriter<?> field : this.fields) {
            total += field.ramBytesUsed();
        }
        return total;
    }

    @Override
    public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        switch (fieldInfo.getVectorEncoding()) {
            case FLOAT32: {
                FloatVectorValues floatVectorValues = KnnVectorsWriter.MergedVectorValues.mergeFloatVectorValues(fieldInfo, mergeState);
                this.writeField(fieldInfo, floatVectorValues, mergeState.segmentInfo.maxDoc());
                break;
            }
            case BYTE: {
                ByteVectorValues byteVectorValues = KnnVectorsWriter.MergedVectorValues.mergeByteVectorValues(fieldInfo, mergeState);
                this.writeField(fieldInfo, byteVectorValues, mergeState.segmentInfo.maxDoc());
            }
        }
    }

    protected abstract void writeField(FieldInfo var1, FloatVectorValues var2, int var3) throws IOException;

    protected abstract void writeField(FieldInfo var1, ByteVectorValues var2, int var3) throws IOException;

    private static class BufferedByteVectorValues
    extends ByteVectorValues {
        final DocsWithFieldSet docsWithField;
        final List<byte[]> vectors;
        final int dimension;
        DocIdSetIterator docsWithFieldIter;
        int ord = -1;

        BufferedByteVectorValues(DocsWithFieldSet docsWithField, List<byte[]> vectors, int dimension) {
            this.docsWithField = docsWithField;
            this.vectors = vectors;
            this.dimension = dimension;
            this.docsWithFieldIter = docsWithField.iterator();
        }

        public BufferedByteVectorValues copy() {
            return new BufferedByteVectorValues(this.docsWithField, this.vectors, this.dimension);
        }

        @Override
        public int dimension() {
            return this.dimension;
        }

        @Override
        public int size() {
            return this.vectors.size();
        }

        @Override
        public byte[] vectorValue() {
            return this.vectors.get(this.ord);
        }

        byte[] vectorValue(int targetOrd) {
            return this.vectors.get(targetOrd);
        }

        @Override
        public int docID() {
            return this.docsWithFieldIter.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int docID = this.docsWithFieldIter.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                ++this.ord;
            }
            return docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public VectorScorer scorer(byte[] target) {
            throw new UnsupportedOperationException();
        }
    }

    private static class BufferedFloatVectorValues
    extends FloatVectorValues {
        final DocsWithFieldSet docsWithField;
        final List<float[]> vectors;
        final int dimension;
        DocIdSetIterator docsWithFieldIter;
        int ord = -1;

        BufferedFloatVectorValues(DocsWithFieldSet docsWithField, List<float[]> vectors, int dimension) {
            this.docsWithField = docsWithField;
            this.vectors = vectors;
            this.dimension = dimension;
            this.docsWithFieldIter = docsWithField.iterator();
        }

        public BufferedFloatVectorValues copy() {
            return new BufferedFloatVectorValues(this.docsWithField, this.vectors, this.dimension);
        }

        @Override
        public int dimension() {
            return this.dimension;
        }

        @Override
        public int size() {
            return this.vectors.size();
        }

        @Override
        public float[] vectorValue() {
            return this.vectors.get(this.ord);
        }

        float[] vectorValue(int targetOrd) {
            return this.vectors.get(targetOrd);
        }

        @Override
        public int docID() {
            return this.docsWithFieldIter.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int docID = this.docsWithFieldIter.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                ++this.ord;
            }
            return docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public VectorScorer scorer(float[] target) {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class FieldWriter<T>
    extends KnnFieldVectorsWriter<T> {
        private final FieldInfo fieldInfo;
        private final int dim;
        private final DocsWithFieldSet docsWithField;
        private final List<T> vectors;
        private int lastDocID = -1;

        FieldWriter(FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
            this.dim = fieldInfo.getVectorDimension();
            this.docsWithField = new DocsWithFieldSet();
            this.vectors = new ArrayList<T>();
        }

        @Override
        public final void addValue(int docID, T value) {
            if (docID == this.lastDocID) {
                throw new IllegalArgumentException("VectorValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
            }
            assert (docID > this.lastDocID);
            this.docsWithField.add(docID);
            this.vectors.add(this.copyValue(value));
            this.lastDocID = docID;
        }

        @Override
        public abstract T copyValue(T var1);

        @Override
        public final long ramBytesUsed() {
            if (this.vectors.size() == 0) {
                return 0L;
            }
            return this.docsWithField.ramBytesUsed() + (long)this.vectors.size() * (long)(RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER) + (long)this.vectors.size() * (long)this.dim * 4L;
        }
    }

    private static class SortingByteVectorValues
    extends ByteVectorValues {
        private final BufferedByteVectorValues randomAccess;
        private final int[] docIdOffsets;
        private int docId = -1;

        SortingByteVectorValues(BufferedByteVectorValues delegate, Sorter.DocMap sortMap) throws IOException {
            int docID;
            this.randomAccess = delegate.copy();
            this.docIdOffsets = new int[sortMap.size()];
            int offset = 1;
            while ((docID = delegate.nextDoc()) != Integer.MAX_VALUE) {
                int newDocID = sortMap.oldToNew(docID);
                this.docIdOffsets[newDocID] = offset++;
            }
        }

        @Override
        public int docID() {
            return this.docId;
        }

        @Override
        public int nextDoc() throws IOException {
            while (this.docId < this.docIdOffsets.length - 1) {
                ++this.docId;
                if (this.docIdOffsets[this.docId] == 0) continue;
                return this.docId;
            }
            this.docId = Integer.MAX_VALUE;
            return this.docId;
        }

        @Override
        public byte[] vectorValue() throws IOException {
            return this.randomAccess.vectorValue(this.docIdOffsets[this.docId] - 1);
        }

        @Override
        public int dimension() {
            return this.randomAccess.dimension();
        }

        @Override
        public int size() {
            return this.randomAccess.size();
        }

        @Override
        public int advance(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public VectorScorer scorer(byte[] target) {
            throw new UnsupportedOperationException();
        }
    }

    private static class SortingFloatVectorValues
    extends FloatVectorValues {
        private final BufferedFloatVectorValues randomAccess;
        private final int[] docIdOffsets;
        private int docId = -1;

        SortingFloatVectorValues(BufferedFloatVectorValues delegate, Sorter.DocMap sortMap) throws IOException {
            int docID;
            this.randomAccess = delegate.copy();
            this.docIdOffsets = new int[sortMap.size()];
            int offset = 1;
            while ((docID = delegate.nextDoc()) != Integer.MAX_VALUE) {
                int newDocID = sortMap.oldToNew(docID);
                this.docIdOffsets[newDocID] = offset++;
            }
        }

        @Override
        public int docID() {
            return this.docId;
        }

        @Override
        public int nextDoc() throws IOException {
            while (this.docId < this.docIdOffsets.length - 1) {
                ++this.docId;
                if (this.docIdOffsets[this.docId] == 0) continue;
                return this.docId;
            }
            this.docId = Integer.MAX_VALUE;
            return this.docId;
        }

        @Override
        public float[] vectorValue() throws IOException {
            return this.randomAccess.vectorValue(this.docIdOffsets[this.docId] - 1);
        }

        @Override
        public int dimension() {
            return this.randomAccess.dimension();
        }

        @Override
        public int size() {
            return this.randomAccess.size();
        }

        @Override
        public int advance(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public VectorScorer scorer(float[] target) {
            throw new UnsupportedOperationException();
        }
    }
}

