/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals;

import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.CachingMatchesIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.ConjunctionMatchesIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.IntervalIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.IntervalMatches;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.IntervalQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.IntervalsSource;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.QueryVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

abstract class MinimizingConjunctionIntervalsSource
extends IntervalsSource {
    protected final List<IntervalsSource> subSources;

    protected MinimizingConjunctionIntervalsSource(List<IntervalsSource> subSources) {
        assert (subSources.size() > 1);
        this.subSources = subSources;
    }

    protected abstract IntervalIterator combine(List<IntervalIterator> var1, MatchCallback var2);

    @Override
    public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        ArrayList<IntervalIterator> subIntervals = new ArrayList<IntervalIterator>();
        for (IntervalsSource source : this.subSources) {
            IntervalIterator it = source.intervals(field, ctx);
            if (it == null) {
                return null;
            }
            subIntervals.add(it);
        }
        return this.combine(subIntervals, MatchCallback.NO_OP);
    }

    @Override
    public IntervalMatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        ArrayList<CachingMatchesIterator> subs = new ArrayList<CachingMatchesIterator>();
        for (IntervalsSource source : this.subSources) {
            IntervalMatchesIterator mi = source.matches(field, ctx, doc);
            if (mi == null) {
                return null;
            }
            subs.add(new CachingMatchesIterator(mi));
        }
        IntervalIterator it = this.combine(subs.stream().map(m4 -> IntervalMatches.wrapMatches(m4, doc)).collect(Collectors.toList()), MinimizingConjunctionIntervalsSource.cacheIterators(subs));
        if (it.advance(doc) != doc) {
            return null;
        }
        if (it.nextInterval() == Integer.MAX_VALUE) {
            return null;
        }
        return new ConjunctionMatchesIterator(it, subs);
    }

    @Override
    public void visit(String field, QueryVisitor visitor) {
        IntervalQuery parent = new IntervalQuery(field, this);
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.MUST, parent);
        for (IntervalsSource source : this.subSources) {
            source.visit(field, v);
        }
    }

    static MatchCallback cacheIterators(Collection<CachingMatchesIterator> its) {
        return () -> {
            for (CachingMatchesIterator it : its) {
                it.cache();
            }
        };
    }

    static interface MatchCallback {
        public static final MatchCallback NO_OP = () -> {};

        public void onMatch() throws IOException;
    }
}

