/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.standard.nodes;

import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.standard.config.PointsConfig;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.standard.nodes.AbstractRangeQueryNode;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.standard.nodes.PointQueryNode;

public class PointRangeQueryNode
extends AbstractRangeQueryNode<PointQueryNode> {
    public PointsConfig numericConfig;

    public PointRangeQueryNode(PointQueryNode lower, PointQueryNode upper, boolean lowerInclusive, boolean upperInclusive, PointsConfig numericConfig) throws QueryNodeException {
        this.setBounds(lower, upper, lowerInclusive, upperInclusive, numericConfig);
    }

    public void setBounds(PointQueryNode lower, PointQueryNode upper, boolean lowerInclusive, boolean upperInclusive, PointsConfig pointsConfig) throws QueryNodeException {
        if (pointsConfig == null) {
            throw new IllegalArgumentException("pointsConfig must not be null!");
        }
        Class<?> lowerNumberType = lower != null && lower.getValue() != null ? lower.getValue().getClass() : null;
        Class<?> upperNumberType = upper != null && upper.getValue() != null ? upper.getValue().getClass() : null;
        if (lowerNumberType != null && !lowerNumberType.equals(pointsConfig.getType())) {
            throw new IllegalArgumentException("lower value's type should be the same as numericConfig type: " + lowerNumberType + " != " + pointsConfig.getType());
        }
        if (upperNumberType != null && !upperNumberType.equals(pointsConfig.getType())) {
            throw new IllegalArgumentException("upper value's type should be the same as numericConfig type: " + upperNumberType + " != " + pointsConfig.getType());
        }
        super.setBounds(lower, upper, lowerInclusive, upperInclusive);
        this.numericConfig = pointsConfig;
    }

    public PointsConfig getPointsConfig() {
        return this.numericConfig;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<pointRange lowerInclusive='");
        sb.append(this.isLowerInclusive());
        sb.append("' upperInclusive='");
        sb.append(this.isUpperInclusive());
        sb.append("' type='");
        sb.append(this.numericConfig.getType().getSimpleName());
        sb.append("'>\n");
        sb.append(this.getLowerBound()).append('\n');
        sb.append(this.getUpperBound()).append('\n');
        sb.append("</pointRange>");
        return sb.toString();
    }
}

