/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.client.protocol;

import com.dataiku.dss.shadelib.org.mlflow_project.apachecommons.logging.Log;
import com.dataiku.dss.shadelib.org.mlflow_project.apachecommons.logging.LogFactory;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.HttpException;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.HttpRequest;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.HttpRequestInterceptor;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.annotation.Contract;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.client.protocol.HttpClientContext;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.conn.routing.RouteInfo;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.protocol.HttpContext;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String PROXY_CONN_DIRECTIVE = "Proxy-Connection";

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            request.setHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            this.log.debug("Connection route not set in the context");
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
        if (route.getHopCount() == 2 && !route.isTunnelled() && !request.containsHeader(PROXY_CONN_DIRECTIVE)) {
            request.addHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
        }
    }
}

