/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionCoreParams;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;

public class WeightingStrategyMethodExtractor
implements ModelExtractor<String> {
    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        if (model instanceof ClassicalPredictionModelDetails) {
            ResolvedClassicalPredictionCoreParams coreParams = ((ClassicalPredictionModelDetails)model).coreParams;
            if (coreParams.weight == null || coreParams.weight.weightMethod == null) {
                return "No weighting";
            }
            String method = "";
            for (WeightMethodName weightMethodName : WeightMethodName.values()) {
                if (!weightMethodName.name().equals(coreParams.weight.weightMethod.name())) continue;
                method = weightMethodName.getUserReadableName();
                break;
            }
            return method;
        }
        throw new IOException("Unable to retrieve preprocessing params for model " + model.fullModelId + " : The class " + String.valueOf(model.getClass()) + " is not supported.");
    }

    public static enum WeightMethodName {
        NO_WEIGHTING("No weighting"),
        SAMPLE_WEIGHT("Sample weights"),
        CLASS_WEIGHT("Class weights"),
        CLASS_AND_SAMPLE_WEIGHT("Class and sample weights");

        private final String userReadableName;

        private WeightMethodName(String userReadableName) {
            this.userReadableName = userReadableName;
        }

        public String getUserReadableName() {
            return this.userReadableName;
        }
    }
}

