/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.clustering;

import com.dataiku.dip.analysis.ml.DKUMLUtils;
import com.dataiku.dip.analysis.ml.MLLibMLTaskHandler;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.clustering.ClusteringParamsExpander;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.ml.shared.ModelStateHelper;
import com.dataiku.dip.analysis.ml.shared.WorkSetPreparator;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.spark.SparkJob;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class MLLibClusteringMLTaskHandler
extends MLLibMLTaskHandler<ClusteringMLTask> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.analysis.clustering");

    public MLLibClusteringMLTaskHandler(AnalysisCoreParams acp, MLTaskLoc taskLoc, ClusteringMLTask task, String sessionId, AuthCtx user) {
        super(acp, taskLoc, task, sessionId, user);
    }

    @Override
    public void init(WorkSetPreparator preparator) throws Exception {
        DKUMLUtils.dumpParamsOnDisk(this.acp, this.taskLoc, this.task, this.sessionId);
        this.ws = new ClusteringParamsExpander((ClusteringMLTask)this.task, this.sessionId).expand();
        preparator.prepare(this.ws);
    }

    @Override
    protected String getAPITicketDescription() {
        return "MLLib doctor clustering";
    }

    @Override
    protected String getDSSMetricName() {
        return "dku.ml.clusteringTrain.mllibTrain";
    }

    @Override
    protected String getHiveDB(SplitDesc splitDesc) throws IOException {
        return DKUMLUtils.getHiveDb(this.acp, this.task, this.datasetsDAO, splitDesc.cparams);
    }

    @Override
    protected void updateTrainInfo(WorkSet.PreprocessingSet pps) throws IOException {
        ModelStateHelper.updateClusteringTrainInfoAndUserMeta(pps);
    }

    @Override
    protected MLLibMLTaskHandler.TrainSparkDoctorJobBuilder getTrainSparkDoctorJobBuilder(final File sessionFolder, final File preprocessingFolder, File modelFolder, SplitDesc splitDesc, String hiveDb) {
        return new MLLibMLTaskHandler.TrainSparkDoctorJobBuilder(this.task, sessionFolder, preprocessingFolder, modelFolder, splitDesc, hiveDb){

            @Override
            public <T extends SparkJob> T buildSparkJob(SparkJobHelper<T> helper, File runDir, SparkSettings sparkSettings, List<SimpleKeyValue> effectiveConf) throws Exception {
                return helper.makeClassJobWithNonSecretGlobalFiles("DSS (Analysis): " + ((ClusteringMLTask)((MLLibClusteringMLTaskHandler)MLLibClusteringMLTaskHandler.this).task).name, effectiveConf, MLLibClusteringMLTaskHandler.this.gatherer.getResourceFiles(), ((ClusteringMLTask)((MLLibClusteringMLTaskHandler)MLLibClusteringMLTaskHandler.this).task).backendType == MLTask.BackendType.H2O, "com.dataiku.dip.spark.MLLibClusteringDoctorJob", ((MLLibClusteringMLTaskHandler)MLLibClusteringMLTaskHandler.this).acp.projectKey, sessionFolder.getAbsolutePath(), preprocessingFolder.getAbsolutePath());
            }

            @Override
            public List<String> getExtraRelevantProjectkeys() {
                return Lists.newArrayList((Object[])new String[]{AnyLoc.resolveSmart(((MLLibClusteringMLTaskHandler)MLLibClusteringMLTaskHandler.this).acp.projectKey, this.splitDesc.cparams.datasetSmartName).getProjectKey()});
            }
        };
    }

    @Override
    protected SplitDesc prepareSplits() throws Exception {
        String trainDS;
        logger.debug((Object)("DATASET AT " + this.acp.inputDatasetSmartName));
        SplitDesc expandedSplitDesc = new SplitDesc("none", "unique-" + ((ClusteringMLTask)this.task).id, (ClusteringMLTask.ClusterSampling)JSON.deepCopy((Object)((ClusteringMLTask)this.task).sampling), this.dataService.getInferredSchemaForML_NT(this.acp, this.user));
        expandedSplitDesc.cparams.datasetSmartName = trainDS = ((ClusteringMLTask)this.task).sampling.datasetSmartName == null ? this.acp.inputDatasetSmartName : ((ClusteringMLTask)this.task).sampling.datasetSmartName;
        expandedSplitDesc.cparams.selection = ((ClusteringMLTask)this.task).sampling.selection;
        JSON.prettyToFile((Object)expandedSplitDesc, (File)new File(this.taskLoc.getSplitsFolder(), expandedSplitDesc.instanceId + ".json"));
        return expandedSplitDesc;
    }
}

