/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.clustering.algorithms.spark;

import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringParameterChecks;
import com.dataiku.dip.analysis.model.clustering.PreTrainClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.algorithms.spark.MLLibAlgorithmMeta;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class MLLibCustomMeta
extends MLLibAlgorithmMeta {
    @Override
    public String generateName(PreTrainClusteringModelingParams rpmp) {
        return StringUtils.isNotBlank((String)rpmp.custom_model_name) ? rpmp.custom_model_name : "Custom MLlib model";
    }

    @Override
    public String generateDescription(PreTrainClusteringModelingParams rpmp) {
        return "";
    }

    @Override
    public void validateParameters(ClusteringModelingParams pmp, ClusteringMLTask task, ClusteringParameterChecks checks) {
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(ClusteringModelingParams pmp, ClusteringMLTask task) {
        ArrayList<WorkSet.ModelingSet> ret = new ArrayList<WorkSet.ModelingSet>();
        if (task.modeling.custom_mllib == null) {
            return ret;
        }
        for (PredictionModelingParams.MLLibCustomGridParams params : task.modeling.custom_mllib) {
            if (!params.enabled) continue;
            PreTrainClusteringModelingParams rcmp = new PreTrainClusteringModelingParams(PreTrainClusteringModelingParams.Algorithm.MLLIB_CUSTOM);
            rcmp.mllib_custom = params;
            rcmp.custom_model_name = params.name;
            ret.add(new WorkSet.ModelingSet(rcmp));
        }
        return ret;
    }
}

