/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.engine;

import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.datamodel.config.DeploymentHookResult;
import com.dataiku.dip.apideployer.deployments.AbstractAPIServiceDockerDeploymentManager;
import com.dataiku.dip.apideployer.deployments.MultiNodeProjectDeploymentManager;
import com.dataiku.dip.apideployer.deployments.SingleNodeProjectDeploymentManager;
import com.dataiku.dip.apideployer.deployments.SingleStaticDeploymentManager;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

@PolyJSON(value={@Mapping(type="PREPARE_PRELOAD_ACTIVATE", value=SingleNodeProjectDeploymentManager.PreparePreloadAndActivateReport.class), @Mapping(type="MULTI_PREPARE_PRELOAD_ACTIVATE", value=MultiNodeProjectDeploymentManager.MultiNodePreparePreloadAndActivateReport.class), @Mapping(type="PREPARE_AND_SYNC", value=SingleStaticDeploymentManager.PrepareAndSyncReport.class), @Mapping(type="DOCKER_BASED", value=AbstractAPIServiceDockerDeploymentManager.DockerBasedDeploymentReport.class)})
public abstract class DeploymentReport
extends InfoMessage.InfoMessages {
    @Nonnull
    public HookExecutionStatus deploymentHookExecutionStatus = new HookExecutionStatus();
    public boolean interrupted;
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.report");

    public abstract void preHookFailure();

    public abstract boolean preDeploymentActionsSucceeded();

    public abstract void setActualDeploymentStepReport(@Nonnull InfoMessage.InfoMessages var1);

    public abstract InfoMessage.Severity getMaxSeverity();

    public abstract DeploymentReport copyHookStatusWithSensitiveDataAdded();

    public abstract DeploymentReport copyWithNonAdminDeploymentFailureMessage();

    public List<HookResult> getHookResults(boolean preHooks) {
        return preHooks ? this.deploymentHookExecutionStatus.preHookResults : this.deploymentHookExecutionStatus.postHookResults;
    }

    public void summarize() {
        super.summarize();
        this.fixMaxSeverity();
    }

    public void mergeFrom(@Nullable InfoMessage.InfoMessages other) {
        super.mergeFrom(other);
        this.fixMaxSeverity();
    }

    private void fixMaxSeverity() {
        if (this.maxSeverity == null) {
            this.maxSeverity = InfoMessage.Severity.SUCCESS;
        }
    }

    public void copyInterruptedAndHookStatus(DeploymentReport other) {
        this.interrupted = other.interrupted;
        this.deploymentHookExecutionStatus = other.deploymentHookExecutionStatus.getSnapshot();
    }

    @Nonnull
    public static Set<InfoMessage> copyWithoutAdminDetails(Set<InfoMessage> messages) {
        return messages.stream().map(m -> {
            if (Objects.equals(m.code, DeployerCodes.ERR_DEPLOYER_UNEXPECTED_ERROR.getCode())) {
                return new InfoMessage(m.severity, m.isFatal, m.title, m.code, String.format("%s. More details may be available in deployment logs.", m.details));
            }
            return m;
        }).collect(Collectors.toSet());
    }

    @Nonnull
    public static Set<InfoMessage> copyWithAdminDetails(Set<InfoMessage> messages) {
        return messages.stream().map(m -> StringUtils.isBlank((String)m.adminDetails) ? m : new InfoMessage(m.severity, m.isFatal, m.title, m.code, String.format("%s: %s", m.details, m.adminDetails))).collect(Collectors.toSet());
    }

    public static class HookExecutionStatus {
        DeploymentStatus deploymentStatus = DeploymentStatus.NOT_STARTED;
        String deploymentStatusMessage;
        public boolean preHookFailed;
        public boolean hasHooks = true;
        public long preHooks = -1L;
        public List<HookResult> preHookResults = new ArrayList<HookResult>();
        public long postHooks = -1L;
        public List<HookResult> postHookResults = new ArrayList<HookResult>();

        public HookExecutionStatus getSnapshot() {
            HookExecutionStatus copy = new HookExecutionStatus();
            copy.deploymentStatus = this.deploymentStatus;
            copy.deploymentStatusMessage = this.deploymentStatusMessage;
            copy.preHookFailed = this.preHookFailed;
            copy.preHooks = this.preHooks;
            copy.preHookResults = this.preHookResults.stream().map(HookResult::getSnapshot).collect(Collectors.toList());
            copy.postHooks = this.postHooks;
            copy.postHookResults = this.postHookResults.stream().map(HookResult::getSnapshot).collect(Collectors.toList());
            return copy;
        }

        public void updateMessageWithSensitiveData() {
            this.preHookResults.forEach(HookResult::updateMessageWithSensitiveData);
            this.postHookResults.forEach(HookResult::updateMessageWithSensitiveData);
        }

        public void skipDeployment(String prefixMessage) {
            logger.warnV("%s because a pre-deployment hook returned an error", new Object[]{prefixMessage});
            this.deploymentStatusMessage = prefixMessage;
            this.deploymentStatus = DeploymentStatus.SKIPPED;
        }

        public void startDeployment(String message) {
            logger.info((Object)message);
            this.deploymentStatusMessage = message;
            this.deploymentStatus = DeploymentStatus.IN_PROGRESS;
        }

        public void failDeployment(String message) {
            logger.error((Object)message);
            this.deploymentStatusMessage = message;
            this.deploymentStatus = DeploymentStatus.FAILED;
        }

        public void interruptDeployment(String message) {
            logger.error((Object)message);
            this.deploymentStatusMessage = message;
            this.deploymentStatus = DeploymentStatus.INTERRUPTED;
        }

        public void noHookDefined() {
            this.hasHooks = false;
        }

        public void succeedDeployment(String message) {
            logger.info((Object)message);
            this.deploymentStatusMessage = message;
            this.deploymentStatus = DeploymentStatus.SUCCESS;
        }

        public void updateStatusAfterDeployment(@Nonnull DeploymentReport report, String prefixMessage) {
            if (report.interrupted) {
                this.interruptDeployment(prefixMessage + " has been interrupted");
            } else if (report.maxSeverity == InfoMessage.Severity.ERROR) {
                this.failDeployment(prefixMessage + " failed");
            } else {
                this.succeedDeployment(prefixMessage + " succeeded");
            }
        }

        static enum DeploymentStatus {
            NOT_STARTED,
            SKIPPED,
            IN_PROGRESS,
            FAILED,
            INTERRUPTED,
            SUCCESS;

        }
    }

    public static class HookResult
    implements Serializable {
        String name;
        HookStatus status = HookStatus.NOT_FINISHED;
        String message;
        transient String sensitiveData;

        public HookResult getSnapshot() {
            HookResult copy = new HookResult();
            copy.name = this.name;
            copy.status = this.status;
            copy.message = this.message;
            copy.sensitiveData = this.sensitiveData;
            return copy;
        }

        public static HookResult startExecutingHook(String name) {
            HookResult hookResult = new HookResult();
            hookResult.name = name;
            return hookResult;
        }

        public void setExecutionResult(DeploymentHookResult result) {
            this.status = HookStatus.valueOf(result.status.toString());
            this.message = result.message;
            this.sensitiveData = result.sensitiveData;
        }

        public void updateMessageWithSensitiveData() {
            if (StringUtils.isNotBlank((String)this.sensitiveData)) {
                this.message = this.message + ". " + this.sensitiveData;
            }
        }

        public void executionInterrupted() {
            this.status = HookStatus.INTERRUPTED;
        }

        public void executionTimedOut() {
            this.status = HookStatus.TIMED_OUT;
        }

        public void executionError() {
            this.status = HookStatus.ERROR;
        }

        static enum HookStatus {
            SUCCESS,
            WARNING,
            ERROR,
            NOT_FINISHED,
            INTERRUPTED,
            TIMED_OUT;

        }
    }
}

