/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.monitoring;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.apideployer.datamodel.config.VertexAIAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deploymentinfo.VertexAIDeploymentInfo;
import com.dataiku.dip.apideployer.deployments.APIServiceDeploymentsService;
import com.dataiku.dip.apideployer.monitoring.ActivityMetric;
import com.dataiku.dip.apideployer.monitoring.ActivityMetricsFetchingService;
import com.dataiku.dip.apideployer.monitoring.ApiEndpointActivityMonitoringService;
import com.dataiku.dip.connections.VertexAIModelDeploymentConnection;
import com.dataiku.dip.dao.UnifiedMonitoringSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.vertexai.VertexAIUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.unifiedmonitoring.externalendpoint.MonitoredExternalApiEndpoint;
import com.dataiku.dip.unifiedmonitoring.externalendpoint.UnifiedMonitoringExternalEndpointsScope;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelibgcp.com.google.api.gax.core.CredentialsProvider;
import com.dataiku.dss.shadelibgcp.com.google.api.gax.core.FixedCredentialsProvider;
import com.dataiku.dss.shadelibgcp.com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.dataiku.dss.shadelibgcp.com.google.api.gax.rpc.TransportChannelProvider;
import com.dataiku.dss.shadelibgcp.com.google.cloud.monitoring.v3.MetricServiceClient;
import com.dataiku.dss.shadelibgcp.com.google.cloud.monitoring.v3.MetricServiceSettings;
import com.dataiku.dss.shadelibgcp.com.google.cloud.resourcemanager.v3.ProjectsSettings;
import com.dataiku.dss.shadelibgcp.com.google.monitoring.v3.Aggregation;
import com.dataiku.dss.shadelibgcp.com.google.monitoring.v3.ListTimeSeriesRequest;
import com.dataiku.dss.shadelibgcp.com.google.monitoring.v3.ListTimeSeriesResponse;
import com.dataiku.dss.shadelibgcp.com.google.monitoring.v3.Point;
import com.dataiku.dss.shadelibgcp.com.google.monitoring.v3.ProjectName;
import com.dataiku.dss.shadelibgcp.com.google.monitoring.v3.TimeInterval;
import com.dataiku.dss.shadelibgcp.com.google.monitoring.v3.TimeSeries;
import com.dataiku.dss.shadelibgcp.com.google.protobuf.Duration;
import com.dataiku.dss.shadelibgcp.com.google.protobuf.util.Timestamps;
import com.dataiku.dss.shadelibgcp.com.google.rpc.Status;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VertexAIActivityMetricsFetchingService
extends ActivityMetricsFetchingService {
    private static final int CLOUDMONITORING_DELAY_MINUTES = 3;
    private static final String ALL_ENDPOINTS_FILTER = "resource.type=\"aiplatform.googleapis.com/Endpoint\"";
    private static final int ALIGNMENT_PERIOD_SECONDS = 60;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.monitoring.vertexAIActivityMetricsFetchingService");

    @Autowired
    public VertexAIActivityMetricsFetchingService(TransactionService transactionService, UnifiedMonitoringSettingsDAO unifiedMonitoringSettingsDAO, APIServiceDeploymentsService apiServiceDeploymentsService) {
        super(transactionService, unifiedMonitoringSettingsDAO, apiServiceDeploymentsService);
    }

    public ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint getInfraActivityMetrics_NT(AuthCtx authCtx, VertexAIAPIDeploymentInfra infra, String overridingConnectionName) {
        ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint timeAndMetricsByDeploymentAndEndpoint;
        block8: {
            TransactionContext.assertNoAttachedTransaction();
            String usedConnection = overridingConnectionName != null ? overridingConnectionName : infra.authConnection;
            String displayedUsedConnection = overridingConnectionName != null ? overridingConnectionName : infra.getDisplayedConnectionName();
            logger.infoV("Getting activity metrics from Google Cloud Monitoring for infrastructure %s using connection %s", new Object[]{infra.id, displayedUsedConnection});
            List<ActivityMetricsFetchingService.DeploymentAndEndpoint<VertexAIDeploymentInfo>> deployments = this.getDeploymentAndEndpoints(infra.id, authCtx);
            logger.infoV("Will fetch activity metrics from Google Cloud Monitoring for at least %d dss endpoints for infrastructure %s using connection %s", new Object[]{deployments.size(), infra.id, displayedUsedConnection});
            MetricServiceClient monitoringClient = this.getCloudMonitoringClient(authCtx, usedConnection);
            try {
                timeAndMetricsByDeploymentAndEndpoint = this.getDssEndpointsActivityMetricsFromCloudMonitoring(infra.gcpProjectId, monitoringClient, deployments);
                if (monitoringClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (monitoringClient != null) {
                        try {
                            monitoringClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DKUSecurityException | IOException | URISyntaxException e) {
                    logger.errorV(e, "Failed to fetch activity metrics from Google Cloud Monitoring for infrastructure %s using connection %s", new Object[]{infra.id, displayedUsedConnection});
                    return new ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint.None();
                }
            }
            monitoringClient.close();
        }
        return timeAndMetricsByDeploymentAndEndpoint;
    }

    public ActivityMetric.TimeAndMetricsByEndpoint getScopeActivityMetrics_NT(AuthCtx authCtx, UnifiedMonitoringExternalEndpointsScope.VertexAI externalEndpointsScope) {
        ActivityMetric.TimeAndMetricsByEndpoint timeAndMetricsByEndpoint;
        block8: {
            TransactionContext.assertNoAttachedTransaction();
            logger.infoV("Getting activity metrics from Google Cloud Monitoring for scope %s using connection %s", new Object[]{externalEndpointsScope.name, externalEndpointsScope.connectionName});
            List<MonitoredExternalApiEndpoint> endpoints = externalEndpointsScope.listEndpoints(authCtx);
            logger.infoV("Will fetch activity metrics for at least %d external endpoints for scope %s using connection %s", new Object[]{endpoints.size(), externalEndpointsScope.name, externalEndpointsScope.connectionName});
            MetricServiceClient monitoringClient = this.getCloudMonitoringClient(authCtx, externalEndpointsScope.connectionName);
            try {
                timeAndMetricsByEndpoint = this.getExternalEndpointsActivityMetricsFromCloudMonitoring(monitoringClient, externalEndpointsScope.gcpProjectId, endpoints);
                if (monitoringClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (monitoringClient != null) {
                        try {
                            monitoringClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CodedRuntimeException | DKUSecurityException | IOException | URISyntaxException e) {
                    logger.errorV(e, "Failed to fetch activity metrics from Google Cloud Monitoring for scope %s using connection %s", new Object[]{externalEndpointsScope.name, externalEndpointsScope.connectionName});
                    return new ActivityMetric.TimeAndMetricsByEndpoint.None();
                }
            }
            monitoringClient.close();
        }
        return timeAndMetricsByEndpoint;
    }

    private ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint getDssEndpointsActivityMetricsFromCloudMonitoring(String gcpProjectId, MetricServiceClient monitoringClient, List<ActivityMetricsFetchingService.DeploymentAndEndpoint<VertexAIDeploymentInfo>> deploymentAndEndpoints) throws IOException {
        ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint timeAndMetricsByDeploymentAndEndpoint = new ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint();
        Pair<Instant, Instant> queryRange = this.getMetricsRequestRange(3);
        ListTimeSeriesRequest rateRequest = this.getRateRequest(gcpProjectId, (Instant)queryRange.first, (Instant)queryRange.second);
        logger.infoV("Querying Google Cloud Monitoring for the requests activity metrics of dss endpoints in project %s", new Object[]{gcpProjectId});
        int countDssEndpoints = 0;
        int countExternalEndpoints = 0;
        for (TimeSeries series : VertexAIActivityMetricsFetchingService.queryWithCheck(monitoringClient, rateRequest)) {
            try {
                List<ActivityMetric.Type> metricTypesToFill = this.getRateSeriesMetricTypes(series);
                this.fillTimeAndMetricsByDeploymentAndEndpoint(timeAndMetricsByDeploymentAndEndpoint, series, deploymentAndEndpoints, metricTypesToFill);
                ++countDssEndpoints;
            }
            catch (ActivityMetricsFetchingService.EndpointNotFoundException e) {
                logger.debug((Object)e.getMessage());
                ++countExternalEndpoints;
            }
        }
        logger.infoV("Pulled rate activity metrics from Google Cloud Monitoring for %d dss endpoints. %d external endpoints were detected and skipped.", new Object[]{countDssEndpoints, countExternalEndpoints});
        logger.infoV("Querying Google Cloud Monitoring for the average latency activity metrics of dss endpoints in project %s", new Object[]{gcpProjectId});
        ListTimeSeriesRequest avgLatencyRequest = this.getLatencyRequest(gcpProjectId, Aggregation.Reducer.REDUCE_MEAN, (Instant)queryRange.first, (Instant)queryRange.second);
        countDssEndpoints = 0;
        countExternalEndpoints = 0;
        List<ActivityMetric.Type> metricTypesToFill = Collections.singletonList(ActivityMetric.Type.AVG_PROCESSING_TIME_IN_MS_PER_REQUEST);
        for (TimeSeries timeSeries : VertexAIActivityMetricsFetchingService.queryWithCheck(monitoringClient, avgLatencyRequest)) {
            try {
                this.fillTimeAndMetricsByDeploymentAndEndpoint(timeAndMetricsByDeploymentAndEndpoint, timeSeries, deploymentAndEndpoints, metricTypesToFill);
                ++countDssEndpoints;
            }
            catch (ActivityMetricsFetchingService.EndpointNotFoundException e) {
                logger.warn((Object)e.getMessage());
                ++countExternalEndpoints;
            }
        }
        logger.infoV("Pulled average latency activity metrics from Google Cloud Monitoring for %d dss endpoints. %d external endpoints were detected and skipped.", new Object[]{countDssEndpoints, countExternalEndpoints});
        logger.infoV("Querying Google Cloud Monitoring for the p95 latency activity metrics of dss endpoints in project %s", new Object[]{gcpProjectId});
        ListTimeSeriesRequest p95LatencyRequest = this.getLatencyRequest(gcpProjectId, Aggregation.Reducer.REDUCE_PERCENTILE_95, (Instant)queryRange.first, (Instant)queryRange.second);
        countDssEndpoints = 0;
        countExternalEndpoints = 0;
        metricTypesToFill = Collections.singletonList(ActivityMetric.Type.P95_PROCESSING_TIME_IN_MS_PER_REQUEST);
        for (TimeSeries series : VertexAIActivityMetricsFetchingService.queryWithCheck(monitoringClient, p95LatencyRequest)) {
            try {
                this.fillTimeAndMetricsByDeploymentAndEndpoint(timeAndMetricsByDeploymentAndEndpoint, series, deploymentAndEndpoints, metricTypesToFill);
                ++countDssEndpoints;
            }
            catch (ActivityMetricsFetchingService.EndpointNotFoundException e) {
                logger.warn((Object)e.getMessage());
                ++countExternalEndpoints;
            }
        }
        logger.infoV("Pulled p95 latency activity metrics from Google Cloud Monitoring for %d dss endpoints. %d external endpoints were detected and skipped.", new Object[]{countDssEndpoints, countExternalEndpoints});
        Pair<Long, Long> pair = this.getMetricsRangeAlignedtoAlignmentPeriod((Instant)queryRange.first, (Instant)queryRange.second);
        VertexAIActivityMetricsFetchingService.fillSparseActivityMetrics(timeAndMetricsByDeploymentAndEndpoint, deploymentAndEndpoints, (long)((Long)pair.first), (long)((Long)pair.second));
        ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint withTotalMetrics = ApiEndpointActivityMonitoringService.mapAverageToTotal(timeAndMetricsByDeploymentAndEndpoint);
        return withTotalMetrics;
    }

    private ActivityMetric.TimeAndMetricsByEndpoint getExternalEndpointsActivityMetricsFromCloudMonitoring(MetricServiceClient monitoringClient, String gcpProjectId, List<MonitoredExternalApiEndpoint> endpoints) throws IOException {
        ActivityMetric.TimeAndMetricsByEndpoint timeAndMetricsByEndpoint = new ActivityMetric.TimeAndMetricsByEndpoint();
        Pair<Instant, Instant> queryRange = this.getMetricsRequestRange(3);
        ListTimeSeriesRequest rateRequest = this.getRateRequest(gcpProjectId, (Instant)queryRange.first, (Instant)queryRange.second);
        Set<String> endpointNames = endpoints.stream().map(em -> em.endpointName).collect(Collectors.toSet());
        logger.infoV("Querying Google Cloud Monitoring for the rate activity metrics of external endpoints in project %s", new Object[]{gcpProjectId});
        int countExternalEndpoints = 0;
        for (TimeSeries timeSeries : VertexAIActivityMetricsFetchingService.queryWithCheck(monitoringClient, rateRequest)) {
            try {
                List<ActivityMetric.Type> list = this.getRateSeriesMetricTypes(timeSeries);
                this.fillTimeAndMetricsByEndpoint(timeAndMetricsByEndpoint, endpointNames, timeSeries, list);
                ++countExternalEndpoints;
            }
            catch (ActivityMetricsFetchingService.EndpointNotFoundException endpointNotFoundException) {
                logger.error((Object)endpointNotFoundException.getMessage());
            }
        }
        logger.infoV("Pulled rate activity metrics from Google Cloud Monitoring for %d external endpoints.", new Object[]{countExternalEndpoints});
        logger.infoV("Querying Google Cloud Monitoring for the average latency activity metrics of external endpoints in project %s", new Object[]{gcpProjectId});
        ListTimeSeriesRequest avgLatencyRequest = this.getLatencyRequest(gcpProjectId, Aggregation.Reducer.REDUCE_MEAN, (Instant)queryRange.first, (Instant)queryRange.second);
        countExternalEndpoints = 0;
        for (TimeSeries timeSeries : VertexAIActivityMetricsFetchingService.queryWithCheck(monitoringClient, avgLatencyRequest)) {
            try {
                List<ActivityMetric.Type> metricTypesToFill = Collections.singletonList(ActivityMetric.Type.AVG_PROCESSING_TIME_IN_MS_PER_REQUEST);
                this.fillTimeAndMetricsByEndpoint(timeAndMetricsByEndpoint, endpointNames, timeSeries, metricTypesToFill);
                ++countExternalEndpoints;
            }
            catch (ActivityMetricsFetchingService.EndpointNotFoundException e) {
                logger.error((Object)e.getMessage());
            }
        }
        logger.infoV("Pulled average latency activity metrics from Google Cloud Monitoring for %d external endpoints.", new Object[]{countExternalEndpoints});
        ListTimeSeriesRequest listTimeSeriesRequest = this.getLatencyRequest(gcpProjectId, Aggregation.Reducer.REDUCE_PERCENTILE_95, (Instant)queryRange.first, (Instant)queryRange.second);
        logger.infoV("Querying Google Cloud Monitoring for the p95 latency activity metrics of external endpoints in project %s", new Object[]{gcpProjectId});
        countExternalEndpoints = 0;
        for (TimeSeries series : VertexAIActivityMetricsFetchingService.queryWithCheck(monitoringClient, listTimeSeriesRequest)) {
            try {
                List<ActivityMetric.Type> metricTypesToFill = Collections.singletonList(ActivityMetric.Type.P95_PROCESSING_TIME_IN_MS_PER_REQUEST);
                this.fillTimeAndMetricsByEndpoint(timeAndMetricsByEndpoint, endpointNames, series, metricTypesToFill);
                ++countExternalEndpoints;
            }
            catch (ActivityMetricsFetchingService.EndpointNotFoundException e) {
                logger.error((Object)e.getMessage());
            }
        }
        logger.infoV("Pulled p95 latency activity metrics from Google Cloud Monitoring for %d external endpoints.", new Object[]{countExternalEndpoints});
        Pair<Long, Long> pair = this.getMetricsRangeAlignedtoAlignmentPeriod((Instant)queryRange.first, (Instant)queryRange.second);
        VertexAIActivityMetricsFetchingService.fillSparseActivityMetrics(timeAndMetricsByEndpoint, endpointNames, (long)((Long)pair.first), (long)((Long)pair.second));
        ActivityMetric.TimeAndMetricsByEndpoint withTotalMetrics = ApiEndpointActivityMonitoringService.mapAverageToTotal(timeAndMetricsByEndpoint);
        return withTotalMetrics;
    }

    private List<ActivityMetric.Type> getRateSeriesMetricTypes(TimeSeries series) {
        String responseCode = series.getMetric().getLabelsOrDefault("response_code", "");
        if (responseCode.equals("200")) {
            return Collections.singletonList(ActivityMetric.Type.ALL_REQUESTS_IN_COUNT_PER_S);
        }
        return Arrays.asList(ActivityMetric.Type.ALL_REQUESTS_IN_COUNT_PER_S, ActivityMetric.Type.ERROR_REQUESTS_IN_COUNT_PER_S);
    }

    private void fillTimeAndMetricsByDeploymentAndEndpoint(ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint timeAndMetricsByDeploymentAndEndpoint, TimeSeries timeSeries, List<ActivityMetricsFetchingService.DeploymentAndEndpoint<VertexAIDeploymentInfo>> deploymentAndEndpoints, List<ActivityMetric.Type> activityMetricTypes) throws ActivityMetricsFetchingService.EndpointNotFoundException {
        String vertexEndpointId = timeSeries.getResource().getLabelsOrDefault("endpoint_id", "");
        ActivityMetricsFetchingService.DeploymentAndEndpoint deploymentAndEndpoint = deploymentAndEndpoints.stream().filter(de -> vertexEndpointId.equals(((VertexAIDeploymentInfo)de.deploymentInfo).vertexAIEndpointId)).findFirst().orElseThrow(() -> new ActivityMetricsFetchingService.EndpointNotFoundException(String.format("Could not find endpoint '%s' in the dss endpoint listing", vertexEndpointId)));
        ActivityMetric.TimeAndMetricsForDeployment timeAndMetricsForDeployment = timeAndMetricsByDeploymentAndEndpoint.computeIfAbsent(deploymentAndEndpoint.deploymentId, ActivityMetric.TimeAndMetricsForDeployment::new);
        ActivityMetric.TimeAndMetricsForEndpoint timeAndMetricsForEndpoint = timeAndMetricsForDeployment.timeAndMetricsForEndpoint.computeIfAbsent(deploymentAndEndpoint.endpointId, ActivityMetric.TimeAndMetricsForEndpoint::new);
        ActivityMetric.TimeAndMetricsByTime timeAndMetricsOrderedByTime = timeAndMetricsForEndpoint.timeAndMetricsOrderedByTime;
        VertexAIActivityMetricsFetchingService.fillTimeAndMetricsOrderedByTime(timeAndMetricsOrderedByTime, timeSeries, activityMetricTypes, String.format("dss endpoint '%s' on deployment '%s'", deploymentAndEndpoint.endpointId, deploymentAndEndpoint.deploymentId));
    }

    private void fillTimeAndMetricsByEndpoint(ActivityMetric.TimeAndMetricsByEndpoint timeAndMetricsByEndpoint, Set<String> endpointNames, TimeSeries timeSeries, List<ActivityMetric.Type> activityMetricTypes) throws ActivityMetricsFetchingService.EndpointNotFoundException {
        String vertexEndpointId = timeSeries.getResource().getLabelsOrDefault("endpoint_id", "");
        if (!endpointNames.contains(vertexEndpointId)) {
            throw new ActivityMetricsFetchingService.EndpointNotFoundException(String.format("Could not find endpoint '%s' in the external endpoint listing", vertexEndpointId));
        }
        ActivityMetric.TimeAndMetricsForEndpoint timeAndMetricsForEndpoint = timeAndMetricsByEndpoint.computeIfAbsent(vertexEndpointId, ActivityMetric.TimeAndMetricsForEndpoint::new);
        ActivityMetric.TimeAndMetricsByTime timeAndMetricsOrderedByTime = timeAndMetricsForEndpoint.timeAndMetricsOrderedByTime;
        VertexAIActivityMetricsFetchingService.fillTimeAndMetricsOrderedByTime(timeAndMetricsOrderedByTime, timeSeries, activityMetricTypes, String.format("external endpoint '%s'", vertexEndpointId));
    }

    private static Iterable<TimeSeries> queryWithCheck(MetricServiceClient monitoringClient, ListTimeSeriesRequest request) throws IOException {
        try {
            MetricServiceClient.ListTimeSeriesPagedResponse response = monitoringClient.listTimeSeries(request);
            if (!((ListTimeSeriesResponse)((MetricServiceClient.ListTimeSeriesPage)response.getPage()).getResponse()).getExecutionErrorsList().isEmpty()) {
                throw new IOException(((Status)((ListTimeSeriesResponse)((MetricServiceClient.ListTimeSeriesPage)response.getPage()).getResponse()).getExecutionErrorsList().get(0)).getMessage());
            }
            return response.iterateAll();
        }
        catch (Exception e) {
            throw new IOException("Error while querying Google Cloud Monitoring: ", e);
        }
    }

    private MetricServiceClient getCloudMonitoringClient(AuthCtx authCtx, String connectionName) throws IOException, DKUSecurityException, URISyntaxException {
        VertexAIModelDeploymentConnection connection = (VertexAIModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(authCtx, connectionName);
        FixedCredentialsProvider credentials = VertexAIUtils.createFixedCredentialsProvider(VertexAIUtils.getGoogleCredentials_NT(authCtx, connection));
        InstantiatingGrpcChannelProvider.Builder channelProviderBuilder = ProjectsSettings.defaultGrpcTransportProviderBuilder();
        ProxySettings proxySettings = ExternalInfrasUtils.getProxy(connection);
        ProxyUtils.applyProxySettings((ProxySettings)proxySettings, (InstantiatingGrpcChannelProvider.Builder)channelProviderBuilder);
        MetricServiceSettings settings = ((MetricServiceSettings.Builder)((MetricServiceSettings.Builder)MetricServiceSettings.newBuilder().setCredentialsProvider((CredentialsProvider)credentials)).setTransportChannelProvider((TransportChannelProvider)channelProviderBuilder.build())).build();
        return MetricServiceClient.create((MetricServiceSettings)settings);
    }

    private static void fillTimeAndMetricsOrderedByTime(Map<Long, ActivityMetric.TimeAndMetrics> timeAndMetricsOrderedByTime, TimeSeries timeSeries, List<ActivityMetric.Type> activityMetricTypes, String endpointDesc) {
        List values = timeSeries.getPointsList();
        if (values == null) {
            logger.debugV("The Cloud Monitoring time series for %s is empty", new Object[]{endpointDesc});
            return;
        }
        for (ActivityMetric.Type metricType : activityMetricTypes) {
            for (Point point : values) {
                ActivityMetric.TimeAndMetrics timeAndMetrics = timeAndMetricsOrderedByTime.computeIfAbsent(point.getInterval().getStartTime().getSeconds(), ActivityMetric.TimeAndMetrics::new);
                ActivityMetric metric = timeAndMetrics.activityMetricsByType.computeIfAbsent(metricType, t -> new ActivityMetric((ActivityMetric.Type)t, 0.0));
                metric.setValue(metric.getValue() + point.getValue().getDoubleValue());
            }
            logger.debugV("Pulled activity metric '%s' from Google Cloud Monitoring for %s", new Object[]{metricType, endpointDesc});
        }
    }

    private ListTimeSeriesRequest getRateRequest(String projectId, Instant start, Instant end) {
        TimeInterval interval = TimeInterval.newBuilder().setEndTime(Timestamps.fromMillis((long)end.toEpochMilli())).setStartTime(Timestamps.fromMillis((long)start.toEpochMilli())).build();
        Aggregation rateAggregation = Aggregation.newBuilder().setAlignmentPeriod(Duration.newBuilder().setSeconds(60L).build()).setPerSeriesAligner(Aggregation.Aligner.ALIGN_RATE).addGroupByFields("metric.response_code").addGroupByFields("resource.endpoint_id").setCrossSeriesReducer(Aggregation.Reducer.REDUCE_SUM).build();
        String filter = "resource.type=\"aiplatform.googleapis.com/Endpoint\" metric.type=\"aiplatform.googleapis.com/prediction/online/response_count\"";
        return ListTimeSeriesRequest.newBuilder().setName(ProjectName.of((String)projectId).toString()).setInterval(interval).setFilter(filter).setAggregation(rateAggregation).build();
    }

    private ListTimeSeriesRequest getLatencyRequest(String projectId, Aggregation.Reducer reducer, Instant start, Instant end) {
        TimeInterval interval = TimeInterval.newBuilder().setEndTime(Timestamps.fromMillis((long)end.toEpochMilli())).setStartTime(Timestamps.fromMillis((long)start.toEpochMilli())).build();
        Aggregation latencyAggregation = Aggregation.newBuilder().setAlignmentPeriod(Duration.newBuilder().setSeconds(60L).build()).setPerSeriesAligner(Aggregation.Aligner.ALIGN_SUM).addGroupByFields("resource.endpoint_id").setCrossSeriesReducer(reducer).build();
        String filter = "resource.type=\"aiplatform.googleapis.com/Endpoint\" metric.type=\"aiplatform.googleapis.com/prediction/online/prediction_latencies\" metric.label.\"latency_type\"=\"total\"";
        return ListTimeSeriesRequest.newBuilder().setName(ProjectName.of((String)projectId).toString()).setInterval(interval).setFilter(filter).setAggregation(latencyAggregation).build();
    }

    protected Pair<Long, Long> getMetricsRangeAlignedtoAlignmentPeriod(Instant start, Instant end) {
        long lastDataTimestampSeconds = end.getEpochSecond();
        long startIncluded = start.getEpochSecond();
        long firstDataTimestampSeconds = startIncluded + (lastDataTimestampSeconds - startIncluded) % 60L;
        return new Pair((Object)firstDataTimestampSeconds, (Object)lastDataTimestampSeconds);
    }
}

